/*
 * Decompiled with CFR 0.152.
 */
package org.dstadler.commons.metrics;

public class MovingAverage {
    private final long[] window;
    private long sum = 0L;
    private int fill;
    private int position;

    public MovingAverage(int size) {
        this.checkArgument(size > 0, "Must have a valid window size, but had %s", size);
        this.window = new long[size];
    }

    public void add(long number) {
        if (this.fill == this.window.length) {
            this.sum -= this.window[this.position];
        } else {
            ++this.fill;
        }
        this.sum += number;
        this.window[this.position++] = number;
        if (this.position == this.window.length) {
            this.position = 0;
        }
    }

    public double getAverage() {
        return (double)this.sum / (double)this.fill;
    }

    public long getFirst() {
        if (this.fill == 0) {
            return 0L;
        }
        if (this.fill == this.window.length) {
            return this.window[this.position];
        }
        return this.window[0];
    }

    public long getSum() {
        return this.sum;
    }

    public int getFill() {
        return this.fill;
    }

    public long getLast() {
        if (this.fill == 0) {
            return 0L;
        }
        if (this.position == 0) {
            return this.window[this.fill - 1];
        }
        return this.window[this.position - 1];
    }

    public long[] getWindow() {
        if (this.fill == 0) {
            return new long[0];
        }
        long[] ret = new long[this.fill];
        if (this.fill != this.window.length || this.position == 0) {
            System.arraycopy(this.window, 0, ret, 0, this.fill);
            return ret;
        }
        System.arraycopy(this.window, this.position, ret, 0, this.fill - this.position);
        System.arraycopy(this.window, 0, ret, this.fill - this.position, this.position);
        return ret;
    }

    private void checkArgument(boolean argument, String msg, Object ... args) {
        if (!argument) {
            throw new IllegalArgumentException(String.format(msg, args));
        }
    }
}

