/*
 * Decompiled with CFR 0.152.
 */
package org.dstadler.commons.logging.log4j;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Log4jUtils {
    public static void rolloverLogfile() {
        Logger logger = LogManager.getRootLogger();
        if ("org.apache.logging.log4j.core.Logger".equals(logger.getClass().getCanonicalName())) {
            try {
                Method getAppenders = logger.getClass().getMethod("getAppenders", new Class[0]);
                Map map = (Map)getAppenders.invoke((Object)logger, new Object[0]);
                for (Object appender : map.values()) {
                    if (!"org.apache.logging.log4j.core.appender.RollingFileAppender".equals(appender.getClass().getCanonicalName())) continue;
                    Method getManager = appender.getClass().getMethod("getManager", new Class[0]);
                    Object manager = getManager.invoke(appender, new Object[0]);
                    Method rollover = manager.getClass().getMethod("rollover", new Class[0]);
                    rollover.invoke(manager, new Object[0]);
                }
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                logger.log(Level.FATAL, "Error rolling over log-files for Log4j", (Throwable)e);
            }
        }
    }
}

