/*
 * Decompiled with CFR 0.152.
 */
package org.dstadler.commons.logging.jdk;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.Format;
import java.util.Date;
import java.util.logging.Formatter;
import java.util.logging.LogRecord;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.FastDateFormat;

public class DefaultFormatter
extends Formatter {
    private static final Format DATE_TIME_FORMAT = FastDateFormat.getInstance((String)"yyyy-MM-dd HH:mm:ss");
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private static final StringBuilder BUILDER = new StringBuilder();
    private static final Date DATE = new Date();
    private static final int APP_DEFAULT_LENGTH = 7;
    private static final int LEVEL_DEFAULT_LENGTH = 7;
    private static final int CLASS_DEFAULT_LENGTH = 12;
    private static String appId = null;

    public static void setAppId(String appId) {
        DefaultFormatter.appId = appId;
    }

    @Override
    public synchronized String format(LogRecord record) {
        BUILDER.setLength(0);
        this.appendDateTime(record);
        this.appendApplication();
        this.appendLevel(record);
        this.appendClass(record);
        this.appendMessage(record);
        this.appendThrowable(record);
        this.appendNewLine();
        return BUILDER.toString();
    }

    private void appendDateTime(LogRecord record) {
        DATE.setTime(record.getMillis());
        BUILDER.append(DATE_TIME_FORMAT.format(DATE));
        BUILDER.append(" ");
    }

    private void appendApplication() {
        if (appId != null) {
            BUILDER.append(appId.substring(0, appId.length() > 7 ? 7 : appId.length()));
            BUILDER.append(StringUtils.repeat((String)" ", (int)(7 - appId.length())));
            BUILDER.append(" ");
        }
    }

    private synchronized void appendLevel(LogRecord record) {
        String levelName = record.getLevel().getName();
        BUILDER.append(levelName);
        BUILDER.append(StringUtils.repeat((String)" ", (int)(7 - levelName.length())));
        BUILDER.append(" ");
    }

    private void appendClass(LogRecord record) {
        int lastDot;
        String className = record.getLoggerName();
        if (className == null) {
            className = "<unknown>";
        }
        if ((lastDot = className.lastIndexOf(".")) > 0) {
            className = className.substring(lastDot + 1);
        }
        BUILDER.append("[");
        BUILDER.append(className);
        BUILDER.append("]");
        BUILDER.append(StringUtils.repeat((String)" ", (int)(12 - className.length())));
        BUILDER.append(" ");
    }

    private void appendMessage(LogRecord record) {
        BUILDER.append(this.formatMessage(record));
    }

    private void appendThrowable(LogRecord record) {
        Throwable throwable = record.getThrown();
        if (throwable == null) {
            return;
        }
        this.appendThrowableSource(record);
        this.appendNewLine();
        this.appendStackTrace(throwable);
    }

    private void appendThrowableSource(LogRecord record) {
        BUILDER.append(":");
        BUILDER.append(" ");
        if (record.getSourceClassName() != null) {
            BUILDER.append(record.getSourceClassName());
        }
        if (record.getSourceMethodName() != null) {
            BUILDER.append(" ");
            BUILDER.append(record.getSourceMethodName());
        }
    }

    private void appendStackTrace(Throwable throwable) {
        try {
            StringWriter sw = new StringWriter();
            try (PrintWriter pw = new PrintWriter(sw);){
                throwable.printStackTrace(pw);
            }
            BUILDER.append(sw);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void appendNewLine() {
        BUILDER.append(LINE_SEPARATOR);
    }
}

