/*
 * Decompiled with CFR 0.152.
 */
package org.dstadler.commons.logging.jdk;

import java.text.Format;
import java.util.Date;
import java.util.logging.Formatter;
import java.util.logging.LogRecord;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.FastDateFormat;

public class BriefLogFormatter
extends Formatter {
    private static final Format format = FastDateFormat.getInstance((String)"HH:mm:ss");
    private static final String lineSep = System.getProperty("line.separator");

    @Override
    public String format(LogRecord record) {
        return "[" + StringUtils.repeat((String)" ", (int)(8 - record.getLevel().toString().length())) + record.getLevel() + "|" + StringUtils.repeat((String)" ", (int)(12 - Thread.currentThread().getName().length())) + Thread.currentThread().getName() + "|" + format.format(new Date(record.getMillis())) + "]: " + record.getMessage() + " " + lineSep;
    }
}

