/*
 * Decompiled with CFR 0.152.
 */
package org.dstadler.commons.io;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;

public class BufferedReaderWithPeek
implements AutoCloseable {
    private final BufferedReader delegate;
    private String peekedLine = null;

    public BufferedReaderWithPeek(String file) throws FileNotFoundException {
        this(new BufferedReader(new FileReader(file)));
    }

    public BufferedReaderWithPeek(BufferedReader delegate) {
        this.delegate = delegate;
    }

    public String peekLine() throws IOException {
        if (this.peekedLine == null) {
            this.peekedLine = this.delegate.readLine();
        }
        return this.peekedLine;
    }

    public String readLine() throws IOException {
        if (this.peekedLine != null) {
            String line = this.peekedLine;
            this.peekedLine = null;
            return line;
        }
        return this.delegate.readLine();
    }

    @Override
    public void close() throws IOException {
        this.delegate.close();
    }
}

