/*
 * Decompiled with CFR 0.152.
 */
package org.dstadler.commons.http;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.URLEncoder;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.TimeZone;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.time.FastDateFormat;
import org.dstadler.commons.util.SuppressForbidden;

public class NanoHTTPD {
    private static final Logger logger = Logger.getLogger(NanoHTTPD.class.getName());
    private static final FastDateFormat gmtFrmt = FastDateFormat.getInstance((String)"E, d MMM yyyy HH:mm:ss 'GMT'", (TimeZone)TimeZone.getTimeZone("GMT"), (Locale)Locale.US);
    private static String encoding = null;
    public static final String HTTP_OK = "200 OK";
    public static final String HTTP_REDIRECT = "301 Moved Permanently";
    public static final String HTTP_FORBIDDEN = "403 Forbidden";
    public static final String HTTP_NOTFOUND = "404 Not Found";
    public static final String HTTP_BADREQUEST = "400 Bad Request";
    public static final String HTTP_INTERNALERROR = "500 Internal Server Error";
    public static final String HTTP_NOTIMPLEMENTED = "501 Not Implemented";
    public static final String MIME_PLAINTEXT = "text/plain";
    public static final String MIME_HTML = "text/html";
    public static final String MIME_JSON = "application/json";
    public static final String MIME_DEFAULT_BINARY = "application/octet-stream";
    private final ServerSocket myServerSocket;
    private final Thread myThread;
    private volatile boolean stopping = false;
    private static final Map<String, String> theMimeTypes = new HashMap<String, String>();
    private static final String LICENCE = "Copyright (C) 2001,2005-2010 by Jarno Elonen <elonen@iki.fi>\n\nRedistribution and use in source and binary forms, with or without\nmodification, are permitted provided that the following conditions\nare met:\n\nRedistributions of source code must retain the above copyright notice,\nthis list of conditions and the following disclaimer. Redistributions in\nbinary form must reproduce the above copyright notice, this list of\nconditions and the following disclaimer in the documentation and/or other\nmaterials provided with the distribution. The name of the author may not\nbe used to endorse or promote products derived from this software without\nspecific prior written permission. \n \nTHIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR\nIMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES\nOF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.\nIN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,\nINCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT\nNOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,\nDATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY\nTHEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT\n(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE\nOF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.";

    public static void setEncoding(String encoding) {
        NanoHTTPD.encoding = encoding;
    }

    public Response serve(String uri, String method, Properties header, Properties parms) {
        String value;
        System.out.println(method + " '" + uri + "' ");
        Enumeration<?> e = header.propertyNames();
        while (e.hasMoreElements()) {
            value = (String)e.nextElement();
            System.out.println("  HDR: '" + value + "' = '" + header.getProperty(value) + "'");
        }
        e = parms.propertyNames();
        while (e.hasMoreElements()) {
            value = (String)e.nextElement();
            System.out.println("  PRM: '" + value + "' = '" + parms.getProperty(value) + "'");
        }
        return this.serveFile(uri, header, new File("."), true);
    }

    public NanoHTTPD(int port) throws IOException {
        this(port, null);
    }

    public NanoHTTPD(int port, InetAddress bindHost) throws IOException {
        this(port, bindHost, 0);
    }

    public NanoHTTPD(int port, InetAddress bindHost, final int sessionTimeout) throws IOException {
        this.myServerSocket = new ServerSocket(port, 50, bindHost);
        this.myThread = new Thread("NanoHTTPD Micro Webserver Thread"){

            @Override
            public void run() {
                try {
                    while (true) {
                        Socket socket = NanoHTTPD.this.myServerSocket.accept();
                        if (sessionTimeout > 0) {
                            socket.setSoTimeout(sessionTimeout);
                        }
                        HTTPSession httpSession = new HTTPSession(socket);
                        httpSession.start();
                    }
                }
                catch (IOException e) {
                    if (NanoHTTPD.this.stopping) {
                        logger.log(Level.INFO, "Stopping socket connections: " + e);
                    } else {
                        logger.log(Level.WARNING, "Failed while accepting socket connections.", e);
                    }
                    return;
                }
            }
        };
        this.myThread.setDaemon(true);
        this.myThread.start();
    }

    public void stop() {
        try {
            this.stopping = true;
            this.myServerSocket.close();
            this.myThread.join();
        }
        catch (IOException | InterruptedException e) {
            logger.log(Level.WARNING, "Had unexpected exception during stop", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressForbidden(reason="Allow to exit the application with a return code here")
    public static void main(String[] args) throws IOException {
        NanoHTTPD nh;
        System.out.println("NanoHTTPD 1.14 (C) 2001,2005-2010 Jarno Elonen\n(Command line options: [port] [--licence])\n");
        int lopt = -1;
        for (int i = 0; i < args.length; ++i) {
            if (!args[i].toLowerCase().endsWith("licence")) continue;
            lopt = i;
            System.out.println("Copyright (C) 2001,2005-2010 by Jarno Elonen <elonen@iki.fi>\n\nRedistribution and use in source and binary forms, with or without\nmodification, are permitted provided that the following conditions\nare met:\n\nRedistributions of source code must retain the above copyright notice,\nthis list of conditions and the following disclaimer. Redistributions in\nbinary form must reproduce the above copyright notice, this list of\nconditions and the following disclaimer in the documentation and/or other\nmaterials provided with the distribution. The name of the author may not\nbe used to endorse or promote products derived from this software without\nspecific prior written permission. \n \nTHIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR\nIMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES\nOF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.\nIN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,\nINCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT\nNOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,\nDATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY\nTHEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT\n(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE\nOF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.\n");
        }
        int port = 80;
        if (args.length > 0 && lopt != 0) {
            port = Integer.parseInt(args[0]);
        }
        if (args.length > 1 && args[1].toLowerCase().endsWith("licence")) {
            System.out.println("Copyright (C) 2001,2005-2010 by Jarno Elonen <elonen@iki.fi>\n\nRedistribution and use in source and binary forms, with or without\nmodification, are permitted provided that the following conditions\nare met:\n\nRedistributions of source code must retain the above copyright notice,\nthis list of conditions and the following disclaimer. Redistributions in\nbinary form must reproduce the above copyright notice, this list of\nconditions and the following disclaimer in the documentation and/or other\nmaterials provided with the distribution. The name of the author may not\nbe used to endorse or promote products derived from this software without\nspecific prior written permission. \n \nTHIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR\nIMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES\nOF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.\nIN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,\nINCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT\nNOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,\nDATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY\nTHEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT\n(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE\nOF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.\n");
        }
        try {
            nh = new NanoHTTPD(port);
        }
        catch (IOException ioe) {
            System.err.println("Couldn't start server:\n" + ioe);
            System.exit(-1);
            return;
        }
        System.out.println("Now serving files in port " + port + " from \"" + new File("").getAbsolutePath() + "\"");
        System.out.println("Hit Enter to stop.\n");
        try {
            System.in.read();
        }
        finally {
            nh.stop();
        }
    }

    private String encodeUri(String uri) {
        StringBuilder newUri = new StringBuilder();
        StringTokenizer st = new StringTokenizer(uri, "/ ", true);
        while (st.hasMoreTokens()) {
            String tok = st.nextToken();
            if (tok.equals("/")) {
                newUri.append('/');
                continue;
            }
            if (tok.equals(" ")) {
                newUri.append("%20");
                continue;
            }
            try {
                newUri.append(URLEncoder.encode(tok, "UTF-8"));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {}
        }
        return newUri.toString();
    }

    public Response serveFile(String uriIn, Properties header, File homeDir, boolean allowDirectoryListing) {
        Response response;
        if (!homeDir.isDirectory()) {
            return new Response(HTTP_INTERNALERROR, MIME_PLAINTEXT, "INTERNAL ERRROR: serveFile(): given homeDir is not a directory.");
        }
        Object uri = uriIn.trim().replace(File.separatorChar, '/');
        if (((String)uri).indexOf(63) >= 0) {
            uri = ((String)uri).substring(0, ((String)uri).indexOf(63));
        }
        if (((String)uri).startsWith("..") || ((String)uri).endsWith("..") || ((String)uri).contains("../")) {
            return new Response(HTTP_FORBIDDEN, MIME_PLAINTEXT, "FORBIDDEN: Won't serve ../ for security reasons.");
        }
        File f = new File(homeDir, (String)uri);
        if (!f.exists()) {
            return new Response(HTTP_NOTFOUND, MIME_PLAINTEXT, "Error 404, file not found.");
        }
        if (f.isDirectory()) {
            if (!((String)uri).endsWith("/")) {
                uri = (String)uri + "/";
                Response r = new Response(HTTP_REDIRECT, MIME_HTML, "<html><body>Redirected: <a href=\"" + (String)uri + "\">" + (String)uri + "</a></body></html>");
                r.addHeader("Location", (String)uri);
                return r;
            }
            if (new File(f, "index.html").exists()) {
                f = new File(homeDir, (String)uri + "/index.html");
            } else if (new File(f, "index.htm").exists()) {
                f = new File(homeDir, (String)uri + "/index.htm");
            } else {
                if (allowDirectoryListing) {
                    String msg = this.createDirListing((String)uri, f);
                    return new Response(HTTP_OK, MIME_HTML, msg);
                }
                return new Response(HTTP_FORBIDDEN, MIME_PLAINTEXT, "FORBIDDEN: No directory listing.");
            }
        }
        String mime = this.getMIMEType(f);
        long startFrom = this.getRange(header);
        FileInputStream fis = new FileInputStream(f);
        try {
            if (((InputStream)fis).skip(startFrom) != startFrom) {
                logger.info("Skipped less bytes than expected: " + startFrom);
            }
            Response r = new Response(HTTP_OK, mime, fis);
            r.addHeader("Content-length", "" + (f.length() - startFrom));
            r.addHeader("Content-range", startFrom + "-" + (f.length() - 1L) + "/" + f.length());
            response = r;
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((InputStream)fis).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException ioe) {
                return new Response(HTTP_FORBIDDEN, MIME_PLAINTEXT, "FORBIDDEN: Reading file failed.");
            }
        }
        ((InputStream)fis).close();
        return response;
    }

    private long getRange(Properties header) {
        String range = header.getProperty("range");
        if (range != null && range.startsWith("bytes=")) {
            int minus = (range = range.substring("bytes=".length())).indexOf(45);
            if (minus >= 0) {
                range = range.substring(0, minus);
            }
            try {
                return Long.parseLong(range);
            }
            catch (NumberFormatException nfe) {
                logger.log(Level.WARNING, "Could not parse range specified in the headers: " + range, nfe);
            }
        }
        return 0L;
    }

    private String getMIMEType(File f) throws IOException {
        String mime = null;
        int dot = f.getCanonicalPath().lastIndexOf(46);
        if (dot >= 0) {
            mime = theMimeTypes.get(f.getCanonicalPath().substring(dot + 1).toLowerCase());
        }
        if (mime == null) {
            mime = MIME_DEFAULT_BINARY;
        }
        return mime;
    }

    private String createDirListing(String uri, File f) {
        String u;
        int slash;
        String[] files = f.list();
        StringBuilder msg = new StringBuilder("<html><body><h1>Directory " + uri + "</h1><br/>");
        if (uri.length() > 1 && (slash = (u = uri.substring(0, uri.length() - 1)).lastIndexOf(47)) >= 0 && slash < u.length()) {
            msg.append("<b><a href=\"").append(uri, 0, slash + 1).append("\">..</a></b><br/>");
        }
        for (int i = 0; i < files.length; ++i) {
            File curFile = new File(f, files[i]);
            boolean dir = curFile.isDirectory();
            if (dir) {
                msg.append("<b>");
                int n = i;
                files[n] = files[n] + "/";
            }
            msg.append("<a href=\"").append(this.encodeUri(uri + files[i])).append("\">").append(files[i]).append("</a>");
            if (curFile.isFile()) {
                long len = curFile.length();
                msg.append(" &nbsp;<font size=2>(");
                if (len < 1024L) {
                    msg.append(curFile.length()).append(" bytes");
                } else if (len < 0x100000L) {
                    msg.append(curFile.length() / 1024L).append(".").append(curFile.length() % 1024L / 10L % 100L).append(" KB");
                } else {
                    msg.append(curFile.length() / 0x100000L).append(".").append(curFile.length() % 0x100000L / 10L % 100L).append(" MB");
                }
                msg.append(")</font>");
            }
            msg.append("<br/>");
            if (!dir) continue;
            msg.append("</b>");
        }
        return msg.toString();
    }

    static {
        StringTokenizer st = new StringTokenizer("htm\t\ttext/html html\t\ttext/html txt\t\ttext/plain asc\t\ttext/plain gif\t\timage/gif jpg\t\timage/jpeg jpeg\t\timage/jpeg png\t\timage/png mp3\t\taudio/mpeg m3u\t\taudio/mpeg-url pdf\t\tapplication/pdf doc\t\tapplication/msword ogg\t\tapplication/x-ogg zip\t\tapplication/octet-stream exe\t\tapplication/octet-stream class\t\tapplication/octet-stream ");
        while (st.hasMoreTokens()) {
            theMimeTypes.put(st.nextToken(), st.nextToken());
        }
    }

    private class HTTPSession
    implements Runnable {
        private final Socket mySocket;

        public HTTPSession(Socket s) {
            this.mySocket = s;
        }

        public void start() {
            Thread t = new Thread((Runnable)this, "NanoHTTPD Session Thread");
            t.setDaemon(true);
            t.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                InputStream is = this.mySocket.getInputStream();
                if (is == null) {
                    return;
                }
                BufferedReader in = new BufferedReader(new InputStreamReader(is));
                String inLine = in.readLine();
                try {
                    Response r;
                    if (inLine == null) {
                        return;
                    }
                    StringTokenizer st = new StringTokenizer(inLine);
                    if (!st.hasMoreTokens()) {
                        this.sendError(NanoHTTPD.HTTP_BADREQUEST, "BAD REQUEST: Syntax error. Usage: GET /example/file.html");
                    }
                    String method = st.nextToken();
                    if (!st.hasMoreTokens()) {
                        this.sendError(NanoHTTPD.HTTP_BADREQUEST, "BAD REQUEST: Missing URI. Usage: GET /example/file.html");
                    }
                    String uri = st.nextToken();
                    Properties parms = new Properties();
                    int qmi = uri.indexOf(63);
                    if (qmi >= 0) {
                        this.decodeParms(uri.substring(qmi + 1), parms);
                        uri = this.decodePercent(uri.substring(0, qmi));
                    } else {
                        uri = this.decodePercent(uri);
                    }
                    Properties header = new Properties();
                    if (st.hasMoreTokens()) {
                        this.readProperties(in, header);
                    }
                    if (method.equalsIgnoreCase("POST")) {
                        this.handlePOST(in, parms, header);
                    }
                    if ((r = NanoHTTPD.this.serve(uri, method, header, parms)) == null) {
                        this.sendError(NanoHTTPD.HTTP_INTERNALERROR, "SERVER INTERNAL ERROR: Serve() returned a null response.");
                    } else {
                        this.sendResponse(r.status, r.mimeType, r.header, r.data);
                    }
                }
                catch (InterruptedException st) {
                }
                catch (Throwable e) {
                    logger.log(Level.WARNING, "Had Exception in HTTPSession handling thread", e);
                    String msg = "<html><body>Exception in HTTPSession handling thread, error: " + e.getMessage() + "</body></html>";
                    try {
                        this.sendError(NanoHTTPD.HTTP_INTERNALERROR, msg);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                finally {
                    in.close();
                }
            }
            catch (IOException ioe) {
                try {
                    this.sendError(NanoHTTPD.HTTP_INTERNALERROR, "SERVER INTERNAL ERROR: IOException: " + ioe.getMessage());
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }

        private void readProperties(BufferedReader in, Properties header) throws IOException {
            String line = in.readLine();
            while (line != null && line.trim().length() > 0) {
                int p = line.indexOf(58);
                if (p == -1) {
                    logger.warning("Could not parse property " + line);
                } else {
                    header.put(line.substring(0, p).trim().toLowerCase(), line.substring(p + 1).trim());
                }
                line = in.readLine();
            }
        }

        private void handlePOST(BufferedReader in, Properties parms, Properties header) throws IOException, InterruptedException {
            long size = Long.MAX_VALUE;
            String contentLength = header.getProperty("content-length");
            if (contentLength != null) {
                try {
                    size = Integer.parseInt(contentLength);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            StringBuilder postLine = new StringBuilder();
            char[] buf = new char[512];
            int read = in.read(buf);
            while (read >= 0 && size > 0L && !postLine.toString().endsWith("\r\n")) {
                postLine.append(String.valueOf(buf, 0, read));
                if ((size -= (long)read) <= 0L) continue;
                read = in.read(buf);
            }
            this.decodeParms(postLine.toString().trim(), parms);
        }

        private String decodePercent(String str) throws InterruptedException {
            try {
                StringBuilder sb = new StringBuilder();
                block6: for (int i = 0; i < str.length(); ++i) {
                    char c = str.charAt(i);
                    switch (c) {
                        case '+': {
                            sb.append(' ');
                            continue block6;
                        }
                        case '%': {
                            sb.append((char)Integer.parseInt(str.substring(i + 1, i + 3), 16));
                            i += 2;
                            continue block6;
                        }
                        default: {
                            sb.append(c);
                        }
                    }
                }
                return sb.toString();
            }
            catch (Exception e) {
                this.sendError(NanoHTTPD.HTTP_BADREQUEST, "BAD REQUEST: Bad percent-encoding.");
                return null;
            }
        }

        private void decodeParms(String parms, Properties p) throws InterruptedException {
            if (parms == null) {
                return;
            }
            StringTokenizer st = new StringTokenizer(parms, "&");
            while (st.hasMoreTokens()) {
                String e = st.nextToken();
                int sep = e.indexOf(61);
                if (sep < 0) continue;
                p.put(this.decodePercent(e.substring(0, sep)).trim(), this.decodePercent(e.substring(sep + 1)));
            }
        }

        private void sendError(String status, String msg) throws InterruptedException {
            this.sendResponse(status, NanoHTTPD.MIME_PLAINTEXT, null, new ByteArrayInputStream(msg.getBytes()));
            throw new InterruptedException();
        }

        private void sendResponse(String status, String mime, Properties header, InputStream data) {
            try {
                if (status == null) {
                    throw new Error("sendResponse(): Status can't be null.");
                }
                try (OutputStream out = this.mySocket.getOutputStream();
                     PrintWriter pw = new PrintWriter(out);){
                    pw.print("HTTP/1.0 " + status + " \r\n");
                    if (mime != null) {
                        pw.print("Content-Type: " + mime + "\r\n");
                    }
                    if (header == null || header.getProperty("Date") == null) {
                        pw.print("Date: " + gmtFrmt.format(new Date()) + "\r\n");
                    }
                    if (header != null) {
                        Enumeration<Object> e = header.keys();
                        while (e.hasMoreElements()) {
                            String key = (String)e.nextElement();
                            String value = header.getProperty(key);
                            pw.print(key + ": " + value + "\r\n");
                        }
                    }
                    pw.print("\r\n");
                    pw.flush();
                    if (data != null) {
                        IOUtils.copy((InputStream)data, (OutputStream)out);
                    }
                    out.flush();
                }
                if (data != null) {
                    data.close();
                }
            }
            catch (IOException ioe) {
                try {
                    this.mySocket.close();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
    }

    public static class Response {
        public String status;
        public String mimeType;
        public InputStream data;
        public Properties header = new Properties();

        public Response() {
            this.status = NanoHTTPD.HTTP_OK;
        }

        public Response(String status, String mimeType, InputStream data) {
            this.status = status;
            this.mimeType = mimeType;
            this.data = data;
        }

        public Response(String status, String mimeType, String txt) {
            this.status = status;
            this.mimeType = mimeType;
            try {
                this.data = new ByteArrayInputStream(encoding != null ? txt.getBytes(encoding) : txt.getBytes());
            }
            catch (UnsupportedEncodingException e) {
                logger.log(Level.WARNING, "Unsupported encoding: " + encoding, e);
            }
        }

        public void addHeader(String name, String value) {
            this.header.put(name, value);
        }
    }
}

