/*
 * Decompiled with CFR 0.152.
 */
package org.dstadler.commons.http;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.util.concurrent.ExecutionException;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLContext;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.nio.client.CloseableHttpAsyncClient;
import org.apache.http.impl.nio.client.HttpAsyncClientBuilder;
import org.apache.http.impl.nio.client.HttpAsyncClients;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;
import org.dstadler.commons.http.AbstractClientWrapper;
import org.dstadler.commons.http.HttpClientWrapper;
import org.dstadler.commons.logging.jdk.LoggerFactory;

public class HttpAsyncClientWrapper
extends AbstractClientWrapper
implements Closeable {
    private static final Logger log = LoggerFactory.make();
    private final CloseableHttpAsyncClient httpClient;

    public HttpAsyncClientWrapper(String user, String password, int timeoutMs) {
        super(timeoutMs, true);
        RequestConfig reqConfig = RequestConfig.custom().setSocketTimeout(timeoutMs).setConnectTimeout(timeoutMs).setConnectionRequestTimeout(timeoutMs).build();
        BasicCredentialsProvider credsProvider = new BasicCredentialsProvider();
        credsProvider.setCredentials(new AuthScope(null, -1), (Credentials)new UsernamePasswordCredentials(user, password));
        HttpAsyncClientBuilder builder = HttpAsyncClients.custom().setDefaultCredentialsProvider((CredentialsProvider)credsProvider).setDefaultRequestConfig(reqConfig);
        try {
            SSLContext sslcontext = this.createSSLContext();
            builder.setSSLContext(sslcontext);
        }
        catch (GeneralSecurityException e) {
            log.log(Level.WARNING, "Could not create SSLSocketFactory for accepting all certificates", e);
        }
        this.httpClient = builder.build();
        this.httpClient.start();
    }

    public HttpAsyncClientWrapper(int timeoutMs) {
        super(timeoutMs, false);
        RequestConfig reqConfig = RequestConfig.custom().setSocketTimeout(timeoutMs).setConnectTimeout(timeoutMs).setConnectionRequestTimeout(timeoutMs).build();
        HttpAsyncClientBuilder builder = HttpAsyncClients.custom().setDefaultRequestConfig(reqConfig);
        try {
            SSLContext sslcontext = this.createSSLContext();
            builder.setSSLContext(sslcontext);
        }
        catch (GeneralSecurityException e) {
            log.log(Level.WARNING, "Could not create SSLSocketFactory for accepting all certificates", e);
        }
        this.httpClient = builder.build();
        this.httpClient.start();
    }

    public CloseableHttpAsyncClient getHttpClient() {
        return this.httpClient;
    }

    @Override
    public void close() throws IOException {
        this.httpClient.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void simpleGetInternal(String url, Consumer<InputStream> consumer, String body) throws IOException {
        HttpResponse execute;
        HttpUriRequest httpGet = this.getHttpGet(url, body);
        try {
            if (this.withAuth) {
                HttpClientContext context = HttpClientContext.create();
                HttpHost targetHost = this.getHttpHostWithAuth(url, context);
                execute = (HttpResponse)this.httpClient.execute(targetHost, (HttpRequest)httpGet, (HttpContext)context, null).get();
            } else {
                execute = (HttpResponse)this.httpClient.execute(httpGet, null).get();
            }
        }
        catch (InterruptedException | ExecutionException e) {
            if (e.getCause() instanceof IOException) {
                throw (IOException)e.getCause();
            }
            throw new IOException(e);
        }
        HttpEntity entity = HttpAsyncClientWrapper.checkAndFetch(execute, url);
        try {
            consumer.accept(entity.getContent());
        }
        finally {
            EntityUtils.consume((HttpEntity)entity);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String simplePost(String url, String body) throws IOException {
        String string;
        HttpClientContext context = HttpClientContext.create();
        HttpHost targetHost = this.getHttpHostWithAuth(url, context);
        HttpPost httpPost = new HttpPost(url);
        if (body != null) {
            httpPost.setEntity((HttpEntity)new StringEntity(body));
        }
        HttpResponse response = (HttpResponse)this.httpClient.execute(targetHost, (HttpRequest)httpPost, (HttpContext)context, null).get();
        HttpEntity entity = HttpClientWrapper.checkAndFetch(response, url);
        try {
            string = IOUtils.toString((InputStream)entity.getContent(), (Charset)StandardCharsets.UTF_8);
        }
        catch (Throwable throwable) {
            try {
                EntityUtils.consume((HttpEntity)entity);
                throw throwable;
            }
            catch (InterruptedException | ExecutionException e) {
                if (e.getCause() instanceof IOException) {
                    throw (IOException)e.getCause();
                }
                throw new IOException(e);
            }
        }
        EntityUtils.consume((HttpEntity)entity);
        return string;
    }

    public static String retrieveData(String url) throws IOException {
        return HttpAsyncClientWrapper.retrieveData(url, "", null, 10000);
    }

    public static String retrieveData(String url, String user, String password, int timeoutMs) throws IOException {
        try (HttpAsyncClientWrapper wrapper = new HttpAsyncClientWrapper(user, password, timeoutMs);){
            String string = wrapper.simpleGet(url);
            return string;
        }
    }

    public static HttpEntity checkAndFetch(HttpResponse response, String url) throws IOException {
        return HttpClientWrapper.checkAndFetch(response, url);
    }

    public static void downloadFile(String url, File destination, int timeoutMs) throws IOException, IllegalStateException {
        HttpClientWrapper.downloadFile(url, destination, timeoutMs);
    }
}

