/*
 * Decompiled with CFR 0.152.
 */
package org.dstadler.commons.http;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScheme;
import org.apache.http.client.AuthCache;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.client.BasicAuthCache;
import org.dstadler.commons.http.HttpGetWithBody;

public abstract class AbstractClientWrapper
implements Closeable {
    protected final int timeoutMs;
    protected final boolean withAuth;

    public AbstractClientWrapper(int timeoutMs, boolean withAuth) {
        this.timeoutMs = timeoutMs;
        this.withAuth = withAuth;
    }

    protected SSLContext createSSLContext() throws GeneralSecurityException {
        SSLContext sslcontext = SSLContext.getInstance("TLS");
        sslcontext.init(null, new TrustManager[]{new X509TrustManager(){

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }

            @Override
            public void checkClientTrusted(X509Certificate[] certs, String authType) {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] certs, String authType) {
            }
        }}, new SecureRandom());
        return sslcontext;
    }

    public String simpleGet(String url) throws IOException {
        AtomicReference str = new AtomicReference();
        this.simpleGetInternal(url, inputStream -> {
            try {
                str.set(IOUtils.toString((InputStream)inputStream, (Charset)StandardCharsets.UTF_8));
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }, null);
        return (String)str.get();
    }

    public String simpleGet(String url, String body) throws IOException {
        AtomicReference str = new AtomicReference();
        this.simpleGetInternal(url, inputStream -> {
            try {
                str.set(IOUtils.toString((InputStream)inputStream, (Charset)StandardCharsets.UTF_8));
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }, body);
        return (String)str.get();
    }

    public byte[] simpleGetBytes(String url) throws IOException {
        AtomicReference bytes = new AtomicReference();
        this.simpleGetInternal(url, inputStream -> {
            try {
                bytes.set(IOUtils.toByteArray((InputStream)inputStream));
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }, null);
        return (byte[])bytes.get();
    }

    public void simpleGet(String url, Consumer<InputStream> consumer) throws IOException {
        this.simpleGetInternal(url, consumer, null);
    }

    protected HttpUriRequest getHttpGet(String url, String body) throws UnsupportedEncodingException {
        Object httpGet;
        if (body == null) {
            httpGet = new HttpGet(url);
        } else {
            httpGet = new HttpGetWithBody(url);
            ((HttpGetWithBody)((Object)httpGet)).setEntity((HttpEntity)new StringEntity(body));
        }
        return httpGet;
    }

    protected abstract void simpleGetInternal(String var1, Consumer<InputStream> var2, String var3) throws IOException;

    protected HttpHost getHttpHostWithAuth(String url, HttpClientContext context) throws MalformedURLException {
        BasicAuthCache authCache = new BasicAuthCache();
        BasicScheme basicAuth = new BasicScheme();
        URL cacheUrl = new URL(url);
        HttpHost targetHost = new HttpHost(cacheUrl.getHost(), cacheUrl.getPort(), cacheUrl.getProtocol());
        authCache.put(targetHost, (AuthScheme)basicAuth);
        context.setAuthCache((AuthCache)authCache);
        return targetHost;
    }
}

