/*
 * Decompiled with CFR 0.152.
 */
package org.dstadler.commons.email;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.dstadler.commons.logging.jdk.LoggerFactory;

public class EmailConfig {
    private static final Logger logger = LoggerFactory.make();
    private String subject = "";
    private String from = null;
    private List<String> to = new ArrayList<String>();
    private List<String> cc = new ArrayList<String>();
    private List<String> bcc = new ArrayList<String>();

    public String getSubject() {
        return this.subject;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public String getFrom() {
        return this.from;
    }

    public void setFrom(String from) {
        this.from = from;
    }

    public List<String> getTo() {
        return this.to;
    }

    public String getToAsEmail() {
        return EmailConfig.listToEmail(this.to);
    }

    public void addTo(String toIn) {
        this.to.add(toIn);
    }

    public void setTo(List<String> toIn) {
        this.to = toIn == null ? new ArrayList<String>() : new ArrayList<String>(toIn);
    }

    public List<String> getCc() {
        return this.cc;
    }

    public String getCcAsEmail() {
        return EmailConfig.listToEmail(this.cc);
    }

    public void addCc(String ccIn) {
        this.cc.add(ccIn);
    }

    public void setCc(List<String> ccIn) {
        this.cc = ccIn == null ? new ArrayList<String>() : new ArrayList<String>(ccIn);
    }

    public List<String> getBcc() {
        return this.bcc;
    }

    public String getBccAsEmail() {
        return EmailConfig.listToEmail(this.bcc);
    }

    public void addBcc(String bccIn) {
        this.bcc.add(bccIn);
    }

    public void setBcc(List<String> bccIn) {
        this.bcc = bccIn == null ? new ArrayList<String>() : new ArrayList<String>(bccIn);
    }

    public static String listToEmail(List<String> list) {
        StringBuilder email = new StringBuilder();
        for (String address : list) {
            if (address == null || address.length() == 0) {
                logger.warning("Trying to use email recipient without email address: " + address + " cannot send email to this recipient.");
                continue;
            }
            email.append(address).append(',');
        }
        while (email.length() > 0 && ',' == email.charAt(email.length() - 1)) {
            email.setLength(email.length() - 1);
        }
        return email.toString();
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }
}

