/*
 * Decompiled with CFR 0.152.
 */
package org.dstadler.commons.dynatrace;

import java.util.HashMap;
import java.util.Map;

public class Measure {
    private double value;
    private double adjustmentFactor = 1.0;
    private String dynamicMeasureName;
    private final Map<String, Double> dynamicMeasures = new HashMap<String, Double>();

    public Measure() {
    }

    public Measure(double value) {
        this(null, value);
    }

    public Measure(String dynamicMeasureName) {
        this(dynamicMeasureName, 0.0);
    }

    public Measure(String dynamicMeasureName, double value) {
        this.dynamicMeasureName = dynamicMeasureName;
        this.value = value;
    }

    public void setAdjustmentFactor(double adjustmentFactor) {
        this.adjustmentFactor = adjustmentFactor;
    }

    public double getValue() {
        return this.value * this.adjustmentFactor;
    }

    public void setValue(double value) {
        this.value = value;
    }

    public String getDynamicMeasureName() {
        return this.dynamicMeasureName;
    }

    public Map<String, Double> getDynamicMeasures() {
        HashMap<String, Double> adjustedMap = new HashMap<String, Double>();
        for (Map.Entry<String, Double> entry : this.dynamicMeasures.entrySet()) {
            adjustedMap.put(entry.getKey(), entry.getValue() * this.adjustmentFactor);
        }
        return adjustedMap;
    }

    public void addDynamicMeasure(String dynamic, double lvalue) {
        Measure.checkNotNull(dynamic, "Cannot add a dynamic measure value when the key of the dynamic measure is null");
        Measure.checkNotNull(this.dynamicMeasureName, "Cannot add a dynamic measure value when the name of the dynamic measure is not set in the constructor");
        if (!this.dynamicMeasures.containsKey(dynamic)) {
            this.dynamicMeasures.put(dynamic, lvalue);
        } else {
            this.dynamicMeasures.put(dynamic, this.dynamicMeasures.get(dynamic) + lvalue);
        }
    }

    public void incValue() {
        this.value += 1.0;
    }

    public void addValue(double lvalue) {
        this.value += lvalue;
    }

    private static void checkNotNull(Object reference, Object errorMessage) {
        if (reference == null) {
            throw new NullPointerException(String.valueOf(errorMessage));
        }
    }
}

