/*
 * Decompiled with CFR 0.152.
 */
package org.dstadler.commons.collections;

import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.dstadler.commons.collections.MappedCounter;

public class MappedCounterImpl<T>
implements MappedCounter<T> {
    private final Map<T, Long> map = new HashMap<T, Long>();

    @Override
    public void add(T k, long v) {
        if (!this.map.containsKey(k)) {
            this.map.put(k, v);
        } else {
            this.map.put(k, this.map.get(k) + v);
        }
    }

    @Override
    public void inc(T k) {
        this.add(k, 1L);
    }

    @Override
    public void count(Collection<T> items) {
        for (T item : items) {
            this.add(item, 1L);
        }
    }

    @Override
    public long get(T k) {
        return this.map.getOrDefault(k, 0L);
    }

    @Override
    public long remove(T key) {
        Long removed = this.map.remove(key);
        if (removed == null) {
            return 0L;
        }
        return removed;
    }

    @Override
    public Set<T> keys() {
        return this.map.keySet();
    }

    @Override
    public Set<Map.Entry<T, Long>> entries() {
        return this.map.entrySet();
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    public Map<T, Long> sortedMap() {
        LinkedList<Map.Entry<T, Long>> list = new LinkedList<Map.Entry<T, Long>>(this.map.entrySet());
        list.sort(new CounterComparator());
        LinkedHashMap result = new LinkedHashMap();
        for (Map.Entry entry : list) {
            result.put(entry.getKey(), (Long)entry.getValue());
        }
        return result;
    }

    @Override
    public long sum() {
        long sum = 0L;
        for (Long i : this.map.values()) {
            sum += i.longValue();
        }
        return sum;
    }

    @Override
    public String toString() {
        return this.map.toString();
    }

    protected static class CounterComparator<T>
    implements Comparator<Map.Entry<T, Long>> {
        protected CounterComparator() {
        }

        @Override
        public int compare(Map.Entry<T, Long> o1, Map.Entry<T, Long> o2) {
            if (o1 == null && o2 == null) {
                return 0;
            }
            if (o1 == null) {
                return 1;
            }
            if (o2 == null) {
                return -1;
            }
            int ret = -1 * o1.getValue().compareTo(o2.getValue());
            if (ret != 0) {
                return ret;
            }
            T key1 = o1.getKey();
            T key2 = o2.getKey();
            if (key1 == null && key2 == null) {
                return 0;
            }
            if (key1 == null) {
                return -1;
            }
            if (key2 == null) {
                return 1;
            }
            if (key1 instanceof Comparable && key2 instanceof Comparable && key1.getClass().isAssignableFrom(key2.getClass())) {
                return ((Comparable)key1).compareTo(key2);
            }
            return key1.toString().compareTo(key2.toString());
        }
    }
}

