/*
 * Decompiled with CFR 0.152.
 */
package org.dstadler.commons.collections;

public class CollectionUtils {
    private CollectionUtils() {
    }

    public static <T extends Number> String getCombinedText(Iterable<T> numbers) {
        StringBuilder text = new StringBuilder();
        long prev = Long.MIN_VALUE;
        long start = Long.MIN_VALUE;
        for (Number nr : numbers) {
            if (prev != nr.longValue() - 1L) {
                if (prev != Long.MIN_VALUE) {
                    CollectionUtils.appendStreak(text, prev, start);
                }
                start = nr.longValue();
            }
            prev = nr.longValue();
        }
        if (prev != Long.MIN_VALUE) {
            CollectionUtils.appendStreak(text, prev, start);
        }
        if (text.length() > 0) {
            text.setLength(text.length() - 1);
        }
        return text.toString();
    }

    private static void appendStreak(StringBuilder text, long prev, long start) {
        if (start == prev) {
            text.append(start).append(",");
        } else if (start == prev - 1L) {
            text.append(start).append(",").append(prev).append(",");
        } else {
            text.append(start).append("-").append(prev).append(",");
        }
    }
}

