/*
 * Decompiled with CFR 0.152.
 */
package org.dstadler.commons.zip;

import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.NoSuchFileException;
import java.util.Enumeration;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.dstadler.commons.io.DeleteOnCloseInputStream;
import org.dstadler.commons.zip.ZipFileCloseInputStream;

public class ZipUtils {
    private static final Logger logger = Logger.getLogger(ZipUtils.class.getName());
    private static final char ZIP_DELIMITER = '!';
    private static final String[] ZIP_EXTENSIONS = new String[]{".zip", ".jar", ".war", ".ear", ".aar", ".hpi", ".xlsx", ".docx", ".pptx"};

    public static boolean isZip(String fileName) {
        if (fileName == null) {
            return false;
        }
        String tl = fileName.toLowerCase();
        for (String element : ZIP_EXTENSIONS) {
            if (!tl.endsWith(element)) continue;
            return true;
        }
        return false;
    }

    public static boolean isFileInZip(String name) {
        if (name == null) {
            return false;
        }
        for (String element : ZIP_EXTENSIONS) {
            if (!name.toLowerCase().contains(element + '!')) continue;
            return true;
        }
        return false;
    }

    public static void findZip(String zipName, InputStream zipInput, FileFilter searchFilter, List<String> results) throws IOException {
        ZipInputStream zin = new ZipInputStream(zipInput);
        while (true) {
            ZipEntry en;
            try {
                en = zin.getNextEntry();
            }
            catch (IOException | IllegalArgumentException e) {
                throw new IOException("While handling file " + zipName, e);
            }
            if (en == null) break;
            if (searchFilter.accept(new File(en.getName()))) {
                results.add(zipName + '!' + en);
            }
            if (!ZipUtils.isZip(en.getName())) continue;
            ZipUtils.findZip(zipName + '!' + en, zin, searchFilter, results);
        }
    }

    public static InputStream getZipContentsRecursive(String file) throws IOException {
        int pos = file.indexOf(33);
        if (pos == -1) {
            if (!new File(file).exists()) {
                throw new IOException("File " + file + " does not exist");
            }
            try {
                return new FileInputStream(file);
            }
            catch (IOException e) {
                if (e.getMessage().contains("because another process has locked")) {
                    logger.warning("Could not read file: " + file + " because it is locked.");
                    return new ByteArrayInputStream(new byte[0]);
                }
                throw e;
            }
        }
        String zip = file.substring(0, pos);
        String subfile = file.substring(pos + 1);
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Trying to read zipfile: " + zip + " subfile: " + subfile);
        }
        if (!(new File(zip).exists() && new File(zip).isFile() && new File(zip).canRead() && new File(zip).length() != 0L)) {
            throw new IOException("ZIP file: " + zip + " does not exist or is empty or not a readable file.");
        }
        ZipFile zipfile = new ZipFile(zip);
        pos = subfile.indexOf(33);
        if (pos != -1) {
            String remainder = subfile.substring(pos + 1);
            File subzipfile = File.createTempFile("ZipUtils", ".zip");
            try {
                ZipUtils.readToTemporaryFile(pos, zip, subfile, zipfile, subzipfile);
                DeleteOnCloseInputStream deleteOnCloseInputStream = new DeleteOnCloseInputStream(new ZipFileCloseInputStream(ZipUtils.getZipContentsRecursive(subzipfile.getAbsolutePath() + '!' + remainder), zipfile), subzipfile);
                return deleteOnCloseInputStream;
            }
            catch (IOException e) {
                zipfile.close();
                throw e;
            }
            finally {
                if (!subzipfile.delete()) {
                    logger.warning("Could not delete file " + subzipfile);
                }
            }
        }
        ZipEntry entry = zipfile.getEntry(subfile);
        return new ZipFileCloseInputStream(zipfile.getInputStream(entry), zipfile);
    }

    private static void readToTemporaryFile(int pos, String zip, String subfile, ZipFile zipfile, File subzipfile) throws IOException {
        ZipEntry entry = ZipUtils.openInnerZip(pos, zip, subfile, zipfile);
        try (InputStream zipstr = zipfile.getInputStream(entry);){
            FileUtils.copyInputStreamToFile((InputStream)zipstr, (File)subzipfile);
        }
    }

    private static ZipEntry openInnerZip(int pos, String zip, String subfile, ZipFile zipfile) throws IOException {
        String zipInner = subfile.substring(0, pos);
        ZipEntry entry = zipfile.getEntry(zipInner);
        if (entry == null) {
            throw new IOException("Could not read inner ZIP file: '" + zipInner + "' from ZIP file '" + zip + "'");
        }
        return entry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public static String getZipStringContentsRecursive(String file) throws IOException {
        block35: {
            block34: {
                pos = file.indexOf(33);
                if (pos == -1) {
                    block33: {
                        if (!new File(file).exists()) {
                            throw new IOException("File " + file + " does not exist");
                        }
                        str = new FileInputStream(file);
                        if (str.available() <= 0) break block33;
                        var3_5 = IOUtils.toString((InputStream)str, (Charset)StandardCharsets.UTF_8);
                        str.close();
                        return var3_5;
                    }
                    var3_6 = "";
                    {
                        catch (Throwable var3_7) {
                            try {
                                try {
                                    str.close();
                                }
                                catch (Throwable var4_9) {
                                    var3_7.addSuppressed(var4_9);
                                }
                                throw var3_7;
                            }
                            catch (IOException e) {
                                if (e.getMessage().contains("because another process has locked")) {
                                    ZipUtils.logger.warning("Could not read file: " + file + " because it is locked.");
                                    return "";
                                }
                                throw e;
                            }
                        }
                    }
                    str.close();
                    return var3_6;
                }
                zip = file.substring(0, pos);
                subfile = file.substring(pos + 1);
                if (ZipUtils.logger.isLoggable(Level.FINE)) {
                    ZipUtils.logger.fine("Trying to read zipfile: " + zip + " subfile: " + subfile);
                }
                if (!(new File(zip).exists() && new File(zip).isFile() && new File(zip).canRead() && new File(zip).length() != 0L)) {
                    throw new IOException("ZIP file: " + zip + " does not exist or is empty or not a readable file.");
                }
                zipfile = new ZipFile(zip);
                pos = subfile.indexOf(33);
                if (pos != -1) {
                    remainder = subfile.substring(pos + 1);
                    subzipfile = File.createTempFile("SearchZip", ".zip");
                    try {
                        ZipUtils.readToTemporaryFile(pos, zip, subfile, zipfile, subzipfile);
                        var7_15 = ZipUtils.getZipStringContentsRecursive(subzipfile.getAbsolutePath() + '!' + remainder);
                        return var7_15;
                    }
                    finally {
                        if (!subzipfile.delete()) {
                            ZipUtils.logger.warning("Could not delete file " + subzipfile);
                        }
                    }
                }
                entry = zipfile.getEntry(subfile);
                str = zipfile.getInputStream(entry);
                if (str.available() <= 0) ** GOTO lbl-1000
                var7_16 = IOUtils.toString((InputStream)str, (Charset)StandardCharsets.UTF_8);
                if (str == null) break block34;
                {
                    catch (Throwable var7_18) {
                        if (str != null) {
                            try {
                                str.close();
                            }
                            catch (Throwable var8_20) {
                                var7_18.addSuppressed(var8_20);
                            }
                        }
                        throw var7_18;
                    }
                }
                str.close();
            }
            return var7_16;
lbl-1000:
            // 1 sources

            {
                var7_17 = "";
                if (str == null) break block35;
                str.close();
            }
        }
        return var7_17;
        finally {
            zipfile.close();
        }
    }

    public static void extractZip(File zip, File toDir) throws IOException {
        if (!toDir.exists()) {
            throw new IOException("Directory '" + toDir + "' does not exist.");
        }
        try (ZipFile zipFile = new ZipFile(zip);){
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                File target = new File(toDir, entry.getName());
                if (entry.isDirectory()) {
                    if (target.mkdirs()) continue;
                    logger.warning("Could not create directory " + target);
                    continue;
                }
                if (!target.getParentFile().exists() && !target.getParentFile().mkdirs()) {
                    logger.warning("Could not create directory " + target.getParentFile());
                }
                InputStream inputStream = zipFile.getInputStream(entry);
                try (BufferedOutputStream outputStream = new BufferedOutputStream(new FileOutputStream(target));){
                    IOUtils.copy((InputStream)inputStream, (OutputStream)outputStream);
                }
                finally {
                    if (inputStream == null) continue;
                    inputStream.close();
                }
            }
        }
        catch (FileNotFoundException | NoSuchFileException e) {
            throw e;
        }
        catch (IOException e) {
            throw new IOException("While extracting file " + zip + " to " + toDir, e);
        }
    }

    public static void extractZip(InputStream zip, final File toDir) throws IOException {
        if (!toDir.exists()) {
            throw new IOException("Directory '" + toDir + "' does not exist.");
        }
        new ZipFileVisitor(){

            @Override
            public void visit(ZipEntry entry, InputStream data) throws IOException {
                File target = new File(toDir, entry.getName());
                if (entry.isDirectory()) {
                    if (!target.mkdirs()) {
                        logger.warning("Could not create directory " + target);
                    }
                    return;
                }
                if (!target.getParentFile().exists() && !target.getParentFile().mkdirs()) {
                    logger.warning("Could not create directory " + target.getParentFile());
                }
                byte[] buffer = new byte[2048];
                try (BufferedOutputStream fout = new BufferedOutputStream(new FileOutputStream(target), buffer.length);){
                    int size;
                    while ((size = data.read(buffer, 0, buffer.length)) != -1) {
                        ((OutputStream)fout).write(buffer, 0, size);
                    }
                }
            }
        }.walk(zip);
    }

    public static void replaceInZip(String zipFile, String data, String encoding) throws IOException {
        if (!ZipUtils.isFileInZip(zipFile)) {
            throw new IOException("Parameter should specify a file inside a ZIP file, but had: " + zipFile);
        }
        File zip = new File(zipFile.substring(0, zipFile.indexOf(33)));
        String zipOut = zipFile.substring(zipFile.indexOf(33) + 1);
        logger.info("Updating containing Zip " + zip + " to " + zipOut);
        ZipUtils.replaceInZip(zip, zipOut, data, encoding);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void replaceInZip(File zip, String file, String data, String encoding) throws IOException {
        File zipOutFile = File.createTempFile("ZipReplace", ".zip");
        try {
            block22: {
                FileOutputStream fos = new FileOutputStream(zipOutFile);
                try (ZipOutputStream zos = new ZipOutputStream(fos);
                     ZipFile zipFile = new ZipFile(zip);){
                    boolean found = false;
                    Enumeration<? extends ZipEntry> entries = zipFile.entries();
                    while (entries.hasMoreElements()) {
                        ZipEntry entry = entries.nextElement();
                        try {
                            if (entry.getName().equals(file)) {
                                zos.putNextEntry(new ZipEntry(entry.getName()));
                                IOUtils.write((String)data, (OutputStream)zos, (String)encoding);
                                found = true;
                                continue;
                            }
                            zos.putNextEntry(entry);
                            IOUtils.copy((InputStream)zipFile.getInputStream(entry), (OutputStream)zos);
                        }
                        finally {
                            zos.closeEntry();
                        }
                    }
                    if (found) break block22;
                    zos.putNextEntry(new ZipEntry(file));
                    try {
                        IOUtils.write((String)data, (OutputStream)zos, (String)"UTF-8");
                    }
                    finally {
                        zos.closeEntry();
                    }
                }
            }
            FileUtils.copyFile((File)zipOutFile, (File)zip);
        }
        finally {
            if (!zipOutFile.delete()) {
                throw new IOException("Error deleting file: " + zipOutFile);
            }
        }
    }

    public static abstract class ZipFileVisitor {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        public void walk(InputStream zipFile) throws IOException {
            block10: {
                stream = new ZipInputStream(zipFile);
                while (true) lbl-1000:
                // 3 sources

                {
                    if ((entry = stream.getNextEntry()) == null) {
                        break block10;
                    }
                    try {
                        this.visit(entry, stream);
                    }
                    finally {
                        stream.closeEntry();
                        continue;
                    }
                    break;
                }
                ** GOTO lbl-1000
                finally {
                    stream.close();
                }
            }
        }

        public abstract void visit(ZipEntry var1, InputStream var2) throws IOException;
    }
}

