/*
 * Decompiled with CFR 0.152.
 */
package org.dstadler.commons.util;

import java.lang.management.LockInfo;
import java.lang.management.ManagementFactory;
import java.lang.management.MonitorInfo;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import org.apache.commons.lang3.SystemUtils;

public class ThreadDump {
    public static final String NEWLINE = System.getProperty("line.separator");
    private static final ThreadMXBean bean = ManagementFactory.getThreadMXBean();
    private ThreadInfo[] infos = bean.dumpAllThreads(lockedMonitors &= bean.isObjectMonitorUsageSupported(), lockedSynchronizers &= bean.isSynchronizerUsageSupported());
    public static final String THREADDUMP_START = "----- BEGIN THREAD DUMP -----";
    public static final String THREADDUMP_END = "------ END THREAD DUMP ------";

    public ThreadDump(boolean lockedMonitors, boolean lockedSynchronizers) {
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(NEWLINE);
        sb.append(THREADDUMP_START);
        sb.append(NEWLINE);
        sb.append("Full thread dump ").append(SystemUtils.JAVA_VERSION).append('(').append(SystemUtils.JAVA_VM_INFO).append("):");
        sb.append(NEWLINE);
        for (ThreadInfo info : this.infos) {
            sb.append(ThreadDump.threadInfoToString(info));
        }
        sb.append(THREADDUMP_END);
        return sb.toString();
    }

    public static String threadInfoToString(ThreadInfo info) {
        StringBuilder sb = new StringBuilder("\"").append(info.getThreadName()).append("\" #").append(info.getThreadId()).append(" tid=").append(ThreadDump.toHexString(info.getThreadId()));
        String lockName = info.getLockName();
        if (lockName != null) {
            String action = " waiting on condition";
            if (lockName.contains("Object.wait")) {
                action = " in Object.wait()";
            }
            sb.append(action);
        }
        sb.append(" [").append(ThreadDump.toHexString(info.hashCode())).append("]\n");
        sb.append("   java.lang.Thread.State: ").append((Object)info.getThreadState());
        if (info.getLockOwnerName() != null) {
            sb.append("(on lock owned by \"");
            sb.append(info.getLockOwnerName()).append("\" <").append(ThreadDump.toHexString(info.getLockOwnerId())).append(">)");
        }
        if (info.isSuspended()) {
            sb.append(" (suspended)");
        }
        if (info.isInNative()) {
            sb.append(" (in native)");
        }
        sb.append('\n');
        StackTraceElement[] stackTrace = info.getStackTrace();
        for (int i = 0; i < stackTrace.length; ++i) {
            MonitorInfo[] lockedMonitors;
            StackTraceElement ste = stackTrace[i];
            sb.append("\tat ").append(ste);
            sb.append('\n');
            if (i == 0 && info.getLockInfo() != null) {
                Thread.State ts = info.getThreadState();
                LockInfo lockInfo = info.getLockInfo();
                long lockId = lockInfo.getIdentityHashCode();
                switch (ts) {
                    case BLOCKED: {
                        sb.append("\t- waiting to lock ").append('<').append(ThreadDump.toHexString(lockId)).append("> (a ").append(lockInfo.getClassName()).append(")\n");
                        break;
                    }
                    case WAITING: 
                    case TIMED_WAITING: {
                        sb.append("\t- parking to wait for ").append('<').append(ThreadDump.toHexString(lockId)).append("> (a ").append(lockInfo.getClassName()).append(")\n");
                        break;
                    }
                }
            }
            for (MonitorInfo mi : lockedMonitors = info.getLockedMonitors()) {
                if (mi.getLockedStackDepth() != i) continue;
                sb.append("\t- locked ").append('<').append(ThreadDump.toHexString(mi.getIdentityHashCode())).append("> (a ").append(mi.getClassName()).append(")\n");
            }
        }
        LockInfo[] locks = info.getLockedSynchronizers();
        if (locks.length > 0) {
            sb.append("\n\tNumber of locked synchronizers = ").append(locks.length);
            sb.append('\n');
            for (LockInfo li : locks) {
                sb.append("\t- ").append(li);
                sb.append('\n');
            }
        }
        sb.append('\n');
        return sb.toString();
    }

    public static String toHexString(long value) {
        return String.format("%#018x", value);
    }
}

