/*
 * Decompiled with CFR 0.152.
 */
package org.dstadler.commons.svn;

import java.util.Arrays;
import org.apache.commons.lang3.StringUtils;
import org.dstadler.commons.svn.LogEntry;
import org.dstadler.commons.xml.AbstractSimpleContentHandler;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class SVNLogFileParser
extends AbstractSimpleContentHandler<Long, LogEntry> {
    private static final int PATH_LIMIT = 3;
    private static final String TAG_LOG_ENTRY = "logentry";
    private static final String TAG_AUTHOR = "author";
    private static final String TAG_DATE = "date";
    private static final String TAG_MSG = "msg";
    private static final String TAG_REVISION = "revision";
    private static final String TAG_PATH = "path";
    private static final String TAG_PATH_ACTION = "action";
    private final String[] branches;
    private final LogEntryRunnable runnable;
    private final int pathLimit;
    private String lastAction = "";

    public SVNLogFileParser(String[] branches) {
        this(branches, null, 3);
    }

    public SVNLogFileParser(String[] branches, LogEntryRunnable runnable, int pathLimit) {
        this.branches = Arrays.copyOf(branches, branches.length);
        this.runnable = runnable;
        this.pathLimit = pathLimit;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (localName.equals(TAG_LOG_ENTRY)) {
            if (this.currentTags != null) {
                throw new IllegalStateException("Should not have tags when a config starts in the XML, but had: " + this.currentTags);
            }
            this.currentTags = new LogEntry();
            if (attributes.getValue(TAG_REVISION) != null) {
                ((LogEntry)this.currentTags).revision = Long.parseLong(attributes.getValue(TAG_REVISION));
            }
        } else if (localName.equals(TAG_PATH)) {
            this.lastAction = attributes.getValue(TAG_PATH_ACTION);
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (localName.equals(TAG_LOG_ENTRY)) {
            if (((LogEntry)this.currentTags).revision == 0L) {
                throw new IllegalStateException("Expected to have tag 'revision' for svn-logentry in the XML, but did not find it in: " + this.currentTags);
            }
            if (this.runnable != null) {
                this.runnable.run((LogEntry)this.currentTags);
            } else {
                this.configs.put(((LogEntry)this.currentTags).revision, (LogEntry)this.currentTags);
            }
            this.currentTags = null;
        } else {
            String value = this.characters.toString().trim();
            switch (localName) {
                case "author": {
                    ((LogEntry)this.currentTags).author = value.toLowerCase();
                    break;
                }
                case "date": {
                    ((LogEntry)this.currentTags).date = value;
                    break;
                }
                case "msg": {
                    ((LogEntry)this.currentTags).msg = value;
                    break;
                }
                case "path": {
                    int size;
                    for (String branch : this.branches) {
                        value = StringUtils.removeStart((String)value, (String)branch);
                    }
                    int n = size = ((LogEntry)this.currentTags).paths == null ? 0 : ((LogEntry)this.currentTags).paths.size();
                    if (size == this.pathLimit) {
                        ((LogEntry)this.currentTags).addPath("...", "");
                    } else if (size < this.pathLimit) {
                        ((LogEntry)this.currentTags).addPath(value, this.lastAction);
                    }
                    this.lastAction = "";
                }
            }
            this.characters.setLength(0);
        }
    }

    public static interface LogEntryRunnable {
        public void run(LogEntry var1);
    }
}

