/*
 * Decompiled with CFR 0.152.
 */
package org.dstadler.commons.svn;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.SortedMap;
import java.util.TimeZone;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.exec.CommandLine;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.dstadler.commons.arrays.ArrayUtils;
import org.dstadler.commons.exec.ExecutionHelper;
import org.dstadler.commons.logging.jdk.LoggerFactory;
import org.dstadler.commons.svn.LogEntry;
import org.dstadler.commons.svn.SVNLogFileParser;
import org.xml.sax.SAXException;

public class SVNCommands {
    private static final Logger log = LoggerFactory.make();
    private static final int COMMIT_RETRY_COUNT = 3;
    public static final String SVN_CMD = "svn";
    private static final String INFINITY = "infinity";
    private static final String AT_REVISION = " at revision ";
    private static final String OPT_XML = "--xml";
    private static final String OPT_DEPTH = "--depth";
    private static final String CMD_MERGE = "merge";
    private static final String CMD_STATUS = "status";
    private static final String CMD_REVERT = "revert";
    private static final String CMD_LOG = "log";
    private static final String CMD_CAT = "cat";

    public static Map<Long, LogEntry> getBranchLog(String[] branches, long startRevision, String baseUrl, String user, String pwd) throws IOException, SAXException {
        SortedMap<Long, LogEntry> sortedMap;
        block8: {
            InputStream inStr = SVNCommands.getBranchLogStream(branches, startRevision, -1L, baseUrl, user, pwd);
            try {
                sortedMap = new SVNLogFileParser(branches).parseContent(inStr);
                if (inStr == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (inStr != null) {
                        try {
                            inStr.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SAXException e) {
                    throw new SAXException("While parsing branch-log of " + Arrays.toString(branches) + ", start: " + startRevision + " with user " + user, e);
                }
            }
            inStr.close();
        }
        return sortedMap;
    }

    public static Map<Long, LogEntry> getBranchLog(String[] branches, long startRevision, long endRevision, String baseUrl, String user, String pwd) throws IOException, SAXException {
        SortedMap<Long, LogEntry> sortedMap;
        block8: {
            InputStream inStr = SVNCommands.getBranchLogStream(branches, startRevision, endRevision, baseUrl, user, pwd);
            try {
                sortedMap = new SVNLogFileParser(branches).parseContent(inStr);
                if (inStr == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (inStr != null) {
                        try {
                            inStr.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SAXException e) {
                    throw new SAXException("While parsing branch-log of " + Arrays.toString(branches) + ", start: " + startRevision + ", end: " + endRevision + " with user " + user, e);
                }
            }
            inStr.close();
        }
        return sortedMap;
    }

    public static Map<Long, LogEntry> getBranchLog(String[] branches, Date startDate, Date endDate, String baseUrl, String user, String pwd) throws IOException, SAXException {
        SortedMap<Long, LogEntry> sortedMap;
        block8: {
            InputStream inStr = SVNCommands.getBranchLogStream(branches, startDate, endDate, baseUrl, user, pwd);
            try {
                sortedMap = new SVNLogFileParser(branches).parseContent(inStr);
                if (inStr == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (inStr != null) {
                        try {
                            inStr.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SAXException e) {
                    throw new SAXException("While parsing branch-log of " + Arrays.toString(branches) + ", start: " + startDate + ", end: " + endDate + " with user " + user, e);
                }
            }
            inStr.close();
        }
        return sortedMap;
    }

    public static InputStream getBranchLogStream(String[] branches, long startRevision, String baseUrl, String user, String pwd) throws IOException {
        return SVNCommands.getBranchLogStream(branches, startRevision, -1L, baseUrl, user, pwd);
    }

    public static InputStream getBranchLogStream(String[] branches, long startRevision, long endRevision, String baseUrl, String user, String pwd) throws IOException {
        CommandLine cmdLine = SVNCommands.getCommandLineForXMLLog(user, pwd);
        cmdLine.addArgument(startRevision + ":" + (endRevision != -1L ? Long.valueOf(endRevision) : "HEAD"));
        cmdLine.addArgument(baseUrl + branches[0]);
        return ExecutionHelper.getCommandResult(cmdLine, new File("."), 0, 120000L);
    }

    public static InputStream getBranchLogStream(String[] branches, Date startDate, Date endDate, String baseUrl, String user, String pwd) throws IOException {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mmZ", Locale.ROOT);
        dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        CommandLine cmdLine = SVNCommands.getCommandLineForXMLLog(user, pwd);
        cmdLine.addArgument("{" + dateFormat.format(startDate) + "}:{" + dateFormat.format(endDate) + "}");
        cmdLine.addArgument(baseUrl + branches[0]);
        return ExecutionHelper.getCommandResult(cmdLine, new File("."), 0, 120000L);
    }

    private static CommandLine getCommandLineForXMLLog(String user, String pwd) {
        CommandLine cmdLine = new CommandLine(SVN_CMD);
        cmdLine.addArgument(CMD_LOG);
        cmdLine.addArgument(OPT_XML);
        SVNCommands.addDefaultArguments(cmdLine, user, pwd);
        cmdLine.addArgument("-v");
        cmdLine.addArgument("-r");
        return cmdLine;
    }

    public static InputStream getRemoteFileContent(String file, long revision, String baseUrl, String user, String pwd) throws IOException {
        CommandLine cmdLine = new CommandLine(SVN_CMD);
        cmdLine.addArgument(CMD_CAT);
        SVNCommands.addDefaultArguments(cmdLine, user, pwd);
        cmdLine.addArgument("-r");
        cmdLine.addArgument(Long.toString(revision));
        cmdLine.addArgument(baseUrl + file);
        return ExecutionHelper.getCommandResult(cmdLine, new File("."), 0, 120000L);
    }

    public static boolean branchExists(String branch, String baseUrl) {
        boolean bl;
        block8: {
            CommandLine cmdLine = new CommandLine(SVN_CMD);
            cmdLine.addArgument(CMD_LOG);
            cmdLine.addArgument(OPT_XML);
            SVNCommands.addDefaultArguments(cmdLine, null, null);
            cmdLine.addArgument("-r");
            cmdLine.addArgument("HEAD:HEAD");
            cmdLine.addArgument(baseUrl + branch);
            InputStream inStr = ExecutionHelper.getCommandResult(cmdLine, new File("."), 0, 120000L);
            try {
                bl = true;
                if (inStr == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (inStr != null) {
                        try {
                            inStr.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    log.log(Level.FINE, "Branch " + branch + " not found or other error", e);
                    return false;
                }
            }
            inStr.close();
        }
        return bl;
    }

    public static long getBranchRevision(String branch, String baseUrl) throws IOException {
        CommandLine cmdLine = new CommandLine(SVN_CMD);
        cmdLine.addArgument(CMD_LOG);
        cmdLine.addArgument(OPT_XML);
        SVNCommands.addDefaultArguments(cmdLine, null, null);
        cmdLine.addArgument("-v");
        cmdLine.addArgument("-r0:HEAD");
        cmdLine.addArgument("--stop-on-copy");
        cmdLine.addArgument("--limit");
        cmdLine.addArgument("1");
        cmdLine.addArgument(baseUrl + branch);
        try (InputStream inStr = ExecutionHelper.getCommandResult(cmdLine, new File("."), 0, 120000L);){
            String xml = IOUtils.toString((InputStream)inStr, (Charset)StandardCharsets.UTF_8);
            log.info("XML:\n" + xml);
            Matcher matcher = Pattern.compile("copyfrom-rev=\"([0-9]+)\"").matcher(xml);
            if (!matcher.find()) {
                throw new IOException("Could not find copyfrom-rev entry in xml: " + xml);
            }
            log.info("Found copyfrom-rev: " + matcher.group(1));
            long l = Long.parseLong(matcher.group(1));
            return l;
        }
    }

    public static long getLastRevision(String branch, String baseUrl, String user, String pwd) throws IOException {
        CommandLine cmdLine = new CommandLine(SVN_CMD);
        cmdLine.addArgument("info");
        SVNCommands.addDefaultArguments(cmdLine, user, pwd);
        cmdLine.addArgument(baseUrl + branch);
        try (InputStream inStr = ExecutionHelper.getCommandResult(cmdLine, new File("."), 0, 120000L);){
            String info = IOUtils.toString((InputStream)inStr, (Charset)StandardCharsets.UTF_8);
            log.info("Info:\n" + info);
            Matcher matcher = Pattern.compile("Revision: ([0-9]+)").matcher(info);
            if (!matcher.find()) {
                throw new IOException("Could not find Revision entry in info-output: " + info);
            }
            log.info("Found rev: " + matcher.group(1) + " for branch " + branch);
            long l = Long.parseLong(matcher.group(1));
            return l;
        }
    }

    private static void addDefaultArguments(CommandLine cmdLine, String user, String pwd) {
        cmdLine.addArgument("--non-interactive");
        cmdLine.addArgument("--trust-server-cert");
        if (StringUtils.isNotEmpty((CharSequence)user) && StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{pwd})) {
            cmdLine.addArgument("--username");
            cmdLine.addArgument(user);
            cmdLine.addArgument("--password");
            cmdLine.addArgument(pwd);
            cmdLine.addArgument("--no-auth-cache");
        }
    }

    public static InputStream getPendingCheckins(File directory) throws IOException {
        CommandLine cmdLine = new CommandLine(SVN_CMD);
        cmdLine.addArgument(CMD_STATUS);
        SVNCommands.addDefaultArguments(cmdLine, null, null);
        return ExecutionHelper.getCommandResult(cmdLine, directory, -1, 120000L);
    }

    public static String getConflicts(File directory) throws IOException {
        try (InputStream stream = SVNCommands.getPendingCheckins(directory);){
            StringBuilder result = new StringBuilder();
            List lines = IOUtils.readLines((InputStream)stream, (String)"UTF-8");
            for (String line : lines) {
                if (line.length() < 2 || line.charAt(0) != 'C' && line.charAt(1) != 'C') continue;
                result.append(line).append("\n");
            }
            String string = result.toString();
            return string;
        }
    }

    public static void commitMergeInfo(String comment, File directory) throws IOException {
        SVNCommands.revertAllButRootDir(directory);
        IOException exception = null;
        for (int i = 0; i < 3; ++i) {
            try {
                SVNCommands.update(directory);
                CommandLine cmdLine = new CommandLine(SVN_CMD);
                cmdLine.addArgument("commit");
                SVNCommands.addDefaultArguments(cmdLine, null, null);
                cmdLine.addArgument("-m");
                cmdLine.addArgument(comment);
                try (InputStream result = ExecutionHelper.getCommandResult(cmdLine, directory, 0, 120000L);){
                    log.info("Svn-Commit reported:\n" + IOUtils.toString((InputStream)result, (Charset)StandardCharsets.UTF_8));
                }
                return;
            }
            catch (IOException e) {
                if (!e.getMessage().contains("Process exited with an error: 1 (Exit value: 1)")) {
                    throw e;
                }
                exception = e;
                log.log(Level.WARNING, "Retrying merge info commit as we had an error which usually indicates that another developer checked in something: " + e.getMessage());
                continue;
            }
        }
        throw exception;
    }

    private static void revertAllButRootDir(File trunkDir) throws IOException {
        log.info("Reverting all but the main directory in " + trunkDir);
        CommandLine cmdLine = new CommandLine(SVN_CMD);
        cmdLine.addArgument(CMD_REVERT);
        SVNCommands.addDefaultArguments(cmdLine, null, null);
        cmdLine.addArgument(OPT_DEPTH);
        cmdLine.addArgument(INFINITY);
        cmdLine.addArgument("*");
        try (InputStream result = ExecutionHelper.getCommandResult(cmdLine, trunkDir, 0, 120000L);){
            log.info("Svn-RevertAllButRootdir reported:\n" + SVNCommands.extractResult(result));
        }
    }

    public static void update(File directory) throws IOException {
        log.info("Updating SVN Working copy at " + directory);
        CommandLine cmdLine = new CommandLine(SVN_CMD);
        SVNCommands.addDefaultArguments(cmdLine, null, null);
        cmdLine.addArgument("up");
        try (InputStream result = ExecutionHelper.getCommandResult(cmdLine, directory, 0, 300000L);){
            log.info("Svn-Update reported:\n" + SVNCommands.extractResult(result));
        }
    }

    public static InputStream recordMerge(File directory, String branchName, long ... revisions) throws IOException {
        CommandLine cmdLine = new CommandLine(SVN_CMD);
        cmdLine.addArgument(CMD_MERGE);
        SVNCommands.addDefaultArguments(cmdLine, null, null);
        cmdLine.addArgument("--record-only");
        cmdLine.addArgument("-c");
        StringBuilder revs = new StringBuilder();
        for (long revision : revisions) {
            revs.append(revision).append(",");
        }
        cmdLine.addArgument(revs.toString());
        cmdLine.addArgument("^" + branchName);
        return ExecutionHelper.getCommandResult(cmdLine, directory, 0, 120000L);
    }

    public static boolean verifyNoPendingChanges(File directory) throws IOException {
        log.info("Checking that there are no pending changes on trunk-working copy");
        try (InputStream inStr = SVNCommands.getPendingCheckins(directory);){
            List lines = IOUtils.readLines((InputStream)inStr, (String)"UTF-8");
            if (lines.size() > 0) {
                log.info("Found the following checkouts:\n" + ArrayUtils.toString(lines.toArray(), "\n"));
                boolean bl = true;
                return bl;
            }
        }
        return false;
    }

    public static MergeResult mergeRevision(long revision, File directory, String branch, String baseUrl) throws IOException {
        CommandLine cmdLine = new CommandLine(SVN_CMD);
        cmdLine.addArgument(CMD_MERGE);
        SVNCommands.addDefaultArguments(cmdLine, null, null);
        cmdLine.addArgument("-x");
        cmdLine.addArgument("-uw --ignore-eol-style");
        cmdLine.addArgument("--accept");
        cmdLine.addArgument("postpone");
        cmdLine.addArgument("-c");
        cmdLine.addArgument(Long.toString(revision));
        cmdLine.addArgument(baseUrl + branch);
        try (InputStream result = ExecutionHelper.getCommandResult(cmdLine, directory, 0, 120000L);){
            String output = SVNCommands.extractResult(result);
            boolean foundActualMerge = false;
            boolean foundConflict = false;
            for (String line : output.split("\n")) {
                if (line.startsWith("--- ")) continue;
                if (line.length() >= 4 && line.substring(0, 4).contains("C")) {
                    foundConflict = true;
                    log.info("Found conflict!");
                    break;
                }
                if (line.startsWith(" U   ") || line.startsWith(" G   ")) continue;
                foundActualMerge = true;
                log.info("Found actual merge: " + line);
            }
            log.info("Svn-Merge reported:\n" + output);
            if (foundConflict) {
                MergeResult mergeResult = MergeResult.Conflicts;
                return mergeResult;
            }
            if (!foundActualMerge) {
                log.info("Only mergeinfo updates found after during merge.");
                MergeResult mergeResult = MergeResult.OnlyMergeInfo;
                return mergeResult;
            }
        }
        return MergeResult.Normal;
    }

    public static String getMergedRevisions(File directory, String ... branches) throws IOException {
        String[] revs;
        CommandLine cmdLine = new CommandLine(SVN_CMD);
        cmdLine.addArgument("propget");
        SVNCommands.addDefaultArguments(cmdLine, null, null);
        cmdLine.addArgument("svn:mergeinfo");
        StringBuilder MERGED_REVISIONS_BUILD = new StringBuilder();
        try (InputStream ignoreStr = ExecutionHelper.getCommandResult(cmdLine, directory, 0, 120000L);){
            List lines = IOUtils.readLines((InputStream)ignoreStr, (String)"UTF-8");
            block5: for (String line : lines) {
                String[] stringArray = branches;
                int n = stringArray.length;
                for (int i = 0; i < n; ++i) {
                    String source = stringArray[i];
                    if (!line.startsWith(source + ":")) continue;
                    log.info("Found merged revisions for branch: " + source);
                    MERGED_REVISIONS_BUILD.append(",").append(line.substring(source.length() + 1));
                    continue block5;
                }
            }
        }
        String MERGED_REVISIONS = StringUtils.removeStart((String)MERGED_REVISIONS_BUILD.toString(), (String)",");
        if (MERGED_REVISIONS.equals("")) {
            throw new IllegalStateException("Could not read merged revision with command " + cmdLine + " in directory " + directory);
        }
        ArrayList<Long> revList = new ArrayList<Long>();
        for (String rev : revs = MERGED_REVISIONS.split(",")) {
            if (rev.contains("-")) {
                String[] revRange = rev.split("-");
                if (revRange.length != 2) {
                    throw new IllegalStateException("Expected to have start and end of range, but had: " + rev);
                }
                for (long r = Long.parseLong(revRange[0]); r <= Long.parseLong(revRange[1]); ++r) {
                    revList.add(r);
                }
                continue;
            }
            rev = StringUtils.removeEnd((String)rev, (String)"*");
            revList.add(Long.parseLong(rev));
        }
        return ((Object)revList).toString();
    }

    public static void revertAll(File directory) throws IOException {
        log.info("Reverting SVN Working copy at " + directory);
        CommandLine cmdLine = new CommandLine(SVN_CMD);
        cmdLine.addArgument(CMD_REVERT);
        SVNCommands.addDefaultArguments(cmdLine, null, null);
        cmdLine.addArgument(OPT_DEPTH);
        cmdLine.addArgument(INFINITY);
        cmdLine.addArgument(directory.getAbsolutePath());
        try (InputStream result = ExecutionHelper.getCommandResult(cmdLine, directory, 0, 120000L);){
            log.info("Svn-RevertAll reported:\n" + SVNCommands.extractResult(result));
        }
    }

    public static void cleanup(File directory) throws IOException {
        log.info("Cleaning SVN Working copy at " + directory);
        CommandLine cmdLine = new CommandLine(SVN_CMD);
        cmdLine.addArgument("cleanup");
        SVNCommands.addDefaultArguments(cmdLine, null, null);
        try (InputStream result = ExecutionHelper.getCommandResult(cmdLine, directory, 0, 360000L);){
            log.info("Svn-Cleanup reported:\n" + SVNCommands.extractResult(result));
        }
    }

    public static InputStream checkout(String url, File directory, String user, String pwd) throws IOException {
        if (!directory.exists() && !directory.mkdirs()) {
            throw new IOException("Could not create new working copy directory at " + directory);
        }
        CommandLine cmdLine = new CommandLine(SVN_CMD);
        cmdLine.addArgument("co");
        SVNCommands.addDefaultArguments(cmdLine, user, pwd);
        cmdLine.addArgument(url);
        cmdLine.addArgument(directory.toString());
        return ExecutionHelper.getCommandResult(cmdLine, directory, -1, 0x6DDD00L);
    }

    protected static String extractResult(InputStream result) throws IOException {
        String string = IOUtils.toString((InputStream)result, (Charset)StandardCharsets.UTF_8).trim();
        return string.equals("\n") ? "" : string;
    }

    public static void copyBranch(String base, String branch, long revision, String baseUrl) throws IOException {
        log.info("Copying branch " + base + AT_REVISION + revision + " to branch " + branch);
        CommandLine cmdLine = new CommandLine(SVN_CMD);
        cmdLine.addArgument("cp");
        SVNCommands.addDefaultArguments(cmdLine, null, null);
        if (revision > 0L) {
            cmdLine.addArgument("-r" + revision);
        }
        cmdLine.addArgument("-m");
        cmdLine.addArgument("Branch automatically created from " + base + (revision > 0L ? AT_REVISION + revision : ""));
        cmdLine.addArgument(baseUrl + base);
        cmdLine.addArgument(baseUrl + branch);
        try (InputStream result = ExecutionHelper.getCommandResult(cmdLine, new File("."), 0, 120000L);){
            log.info("Svn-Copy reported:\n" + SVNCommands.extractResult(result));
        }
    }

    public static boolean checkSVNCommand() {
        boolean bl;
        block8: {
            log.info("Checking if SVN command is available");
            CommandLine cmdLine = new CommandLine(SVN_CMD);
            cmdLine.addArgument("--version");
            InputStream result = ExecutionHelper.getCommandResult(cmdLine, new File("."), 0, 360000L);
            try {
                log.info("Svn-Version reported:\n" + SVNCommands.extractResult(result));
                bl = true;
                if (result == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (result != null) {
                        try {
                            result.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    return false;
                }
            }
            result.close();
        }
        return bl;
    }

    public static enum MergeResult {
        OnlyMergeInfo,
        Normal,
        Conflicts;

    }
}

