/*
 * Decompiled with CFR 0.152.
 */
package org.dstadler.commons.net;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSocketFactory;
import org.apache.commons.io.IOUtils;
import org.dstadler.commons.logging.jdk.LoggerFactory;
import org.dstadler.commons.net.AllowingHostnameVerifier;

public class UrlUtils {
    private static final Logger LOGGER = LoggerFactory.make();
    private static final int REPORT_PEEK_COUNT = 200;

    public static String retrieveData(String sUrl, int timeout) throws IOException {
        return UrlUtils.retrieveData(sUrl, null, timeout);
    }

    public static String retrieveData(String sUrl, String encoding, int timeout) throws IOException {
        return UrlUtils.retrieveData(sUrl, encoding, timeout, null);
    }

    public static String retrieveData(String sUrl, String encoding, int timeout, SSLSocketFactory sslFactory) throws IOException {
        byte[] rawData = UrlUtils.retrieveRawData(sUrl, timeout, sslFactory);
        if (encoding == null) {
            return new String(rawData);
        }
        return new String(rawData, encoding);
    }

    public static byte[] retrieveRawData(String sUrl, int timeout) throws IOException {
        return UrlUtils.retrieveRawData(sUrl, timeout, null);
    }

    public static byte[] retrieveRawData(String sUrl, int timeout, SSLSocketFactory sslFactory) throws IOException {
        URL url = new URL(sUrl);
        LOGGER.fine("Using the following URL for retrieving the data: " + url.toString());
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        if (timeout != 0) {
            conn.setConnectTimeout(timeout);
            conn.setReadTimeout(timeout);
        }
        try {
            byte[] byArray;
            block12: {
                conn.setDoOutput(false);
                conn.setDoInput(true);
                if (conn instanceof HttpsURLConnection && sslFactory != null) {
                    ((HttpsURLConnection)conn).setSSLSocketFactory(sslFactory);
                }
                conn.connect();
                int code = conn.getResponseCode();
                if (code != 200 && code != 201 && code != 202) {
                    String msg = "Error " + code + " returned while retrieving response for url '" + url + "' message from client: " + conn.getResponseMessage();
                    LOGGER.warning(msg);
                    throw new IOException(msg);
                }
                InputStream strm = conn.getInputStream();
                try {
                    byArray = IOUtils.toByteArray((InputStream)strm);
                    if (strm == null) break block12;
                }
                catch (Throwable throwable) {
                    if (strm != null) {
                        try {
                            strm.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                strm.close();
            }
            return byArray;
        }
        finally {
            conn.disconnect();
        }
    }

    public static String retrieveDataPost(String sUrl, String encoding, String postRequestBody, String contentType, int timeout) throws IOException {
        return UrlUtils.retrieveStringInternalPost(sUrl, encoding, postRequestBody, contentType, timeout, null);
    }

    public static String retrieveDataPost(String sUrl, String encoding, String postRequestBody, String contentType, int timeout, SSLSocketFactory sslFactory) throws IOException {
        return UrlUtils.retrieveStringInternalPost(sUrl, encoding, postRequestBody, contentType, timeout, sslFactory);
    }

    private static String retrieveStringInternalPost(String sUrl, String encoding, String postRequestBody, String contentType, int timeout, SSLSocketFactory sslFactory) throws IOException {
        byte[] rawData = UrlUtils.retrieveRawInternalPost(sUrl, postRequestBody, contentType, timeout, sslFactory);
        return encoding != null ? new String(rawData, encoding) : new String(rawData);
    }

    private static byte[] retrieveRawInternalPost(String sUrl, String postRequestBody, String contentType, int timeout, SSLSocketFactory sslFactory) throws IOException {
        if (postRequestBody == null) {
            throw new IllegalArgumentException("POST request body must not be null");
        }
        URL url = new URL(sUrl);
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        try {
            byte[] byArray;
            UrlUtils.prepareConnection(connection, timeout, sslFactory);
            UrlUtils.writePostRequest(connection, postRequestBody, contentType);
            connection.connect();
            int responseCode = connection.getResponseCode();
            if (!UrlUtils.responseCodeValid(responseCode)) {
                String message = "Error " + responseCode + " returned while retrieving response for url " + url + ", response message: " + connection.getResponseMessage();
                LOGGER.warning(message);
                throw new IOException(message);
            }
            try (ByteArrayOutputStream memStream = new ByteArrayOutputStream(connection.getContentLength() == -1 ? 40000 : connection.getContentLength());){
                try (InputStream in = connection.getInputStream();){
                    IOUtils.copy((InputStream)in, (OutputStream)memStream);
                }
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.log(Level.FINE, "Received data, size: " + memStream.size() + " (" + connection.getContentLength() + ") first bytes: " + UrlUtils.replaceInvalidChars(new String(memStream.toByteArray(), 0, Math.min(memStream.size(), 200), StandardCharsets.US_ASCII)));
                }
                byArray = memStream.toByteArray();
            }
            return byArray;
        }
        finally {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "Retrieved URL: " + url + ", header fields: " + connection.getHeaderFields());
            }
            connection.disconnect();
        }
    }

    private static String replaceInvalidChars(String substring) {
        StringBuilder builder = new StringBuilder();
        for (char c : substring.toCharArray()) {
            if (c < ' ') {
                builder.append('.');
                continue;
            }
            builder.append(c);
        }
        return builder.toString();
    }

    private static boolean responseCodeValid(int responseCode) {
        return responseCode / 100 == 2;
    }

    private static void prepareConnection(URLConnection connection, int timeout, SSLSocketFactory sslFactory) {
        if (timeout == 0) {
            throw new IllegalArgumentException("Zero (infinite) timeouts not permitted");
        }
        connection.setConnectTimeout(timeout);
        connection.setReadTimeout(timeout);
        connection.setDoInput(true);
        connection.setDoOutput(false);
        if (connection instanceof HttpsURLConnection && sslFactory != null) {
            ((HttpsURLConnection)connection).setSSLSocketFactory(sslFactory);
        }
    }

    private static void writePostRequest(URLConnection connection, String postRequestBody, String contentType) throws IOException {
        connection.setDoOutput(true);
        if (contentType != null) {
            connection.setRequestProperty("Content-Type", contentType);
        }
        try (DataOutputStream out = new DataOutputStream(connection.getOutputStream());){
            out.writeBytes(postRequestBody);
        }
    }

    public static boolean isAvailable(String destinationUrl, boolean fireRequest, int timeout) throws IllegalArgumentException {
        return UrlUtils.isAvailable(destinationUrl, fireRequest, false, timeout);
    }

    public static boolean isAvailable(String destinationUrl, boolean fireRequest, boolean ignoreHTTPSHostCheck, int timeout) throws IllegalArgumentException {
        return UrlUtils.getAccessError(destinationUrl, fireRequest, ignoreHTTPSHostCheck, timeout, null) == null;
    }

    public static boolean isAvailable(String destinationUrl, boolean fireRequest, boolean ignoreHTTPSHostCheck, int timeout, SSLSocketFactory sslFactory) throws IllegalArgumentException {
        return UrlUtils.getAccessError(destinationUrl, fireRequest, ignoreHTTPSHostCheck, timeout, sslFactory) == null;
    }

    public static String getAccessError(String destinationUrl, boolean fireRequest, boolean ignoreHTTPSHostCheck, int timeout) throws IllegalArgumentException {
        return UrlUtils.getAccessError(destinationUrl, fireRequest, ignoreHTTPSHostCheck, timeout, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getAccessError(String destinationUrl, boolean fireRequest, boolean ignoreHTTPSHostCheck, int timeout, SSLSocketFactory sslFactory) throws IllegalArgumentException {
        URL url;
        try {
            url = new URL(destinationUrl);
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("Invalid destination URL", e);
        }
        HttpURLConnection conn = null;
        try {
            conn = (HttpURLConnection)url.openConnection();
            if (timeout != 0) {
                conn.setConnectTimeout(timeout);
                conn.setReadTimeout(timeout);
            }
            if (ignoreHTTPSHostCheck && conn instanceof HttpsURLConnection) {
                ((HttpsURLConnection)conn).setHostnameVerifier(new AllowingHostnameVerifier());
            }
            if (conn instanceof HttpsURLConnection && sslFactory != null) {
                ((HttpsURLConnection)conn).setSSLSocketFactory(sslFactory);
            }
            conn.setDoOutput(false);
            conn.setDoInput(true);
            conn.connect();
            if (fireRequest) {
                conn.getInputStream().close();
            }
            String string = null;
            return string;
        }
        catch (IOException e) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Connection attempt to '" + destinationUrl + "' failed. Connection refused.");
            }
            String string = e.getClass().getName() + ": " + e.getMessage();
            return string;
        }
        finally {
            if (conn != null) {
                conn.disconnect();
            }
        }
    }
}

