/*
 * Decompiled with CFR 0.152.
 */
package org.dstadler.commons.net;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.util.logging.Logger;
import org.dstadler.commons.util.SuppressForbidden;

public final class SocketUtils {
    private static final Logger log = Logger.getLogger(SocketUtils.class.getName());

    private SocketUtils() {
    }

    @SuppressForbidden(reason="We want to bind to any address here when checking for free ports")
    public static int getNextFreePort(int portRangeStart, int portRangeEnd) throws IOException {
        int port = portRangeStart;
        while (port <= portRangeEnd) {
            int n;
            ServerSocket sock = new ServerSocket();
            try {
                sock.setReuseAddress(true);
                sock.bind(new InetSocketAddress(port));
                n = port;
            }
            catch (Throwable throwable) {
                try {
                    try {
                        sock.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    log.warning("Port " + port + " seems to be used already, trying next one...");
                    ++port;
                }
            }
            sock.close();
            return n;
        }
        throw new IOException("No free port found in the range of [" + portRangeStart + " - " + portRangeEnd + "]");
    }
}

