/*
 * Decompiled with CFR 0.152.
 */
package org.dstadler.commons.metrics;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.logging.Logger;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.util.EntityUtils;
import org.dstadler.commons.http.HttpClientWrapper;
import org.dstadler.commons.logging.jdk.LoggerFactory;

public class MetricsUtils {
    private static final Logger log = LoggerFactory.make();

    public static void sendMetric(String metric, int value, long ts, String url, String user, String password) throws IOException {
        try (HttpClientWrapper metrics = new HttpClientWrapper(user, password, 60000);){
            MetricsUtils.sendMetric(metric, value, ts, metrics.getHttpClient(), url);
        }
    }

    public static void sendMetric(String metric, int value, long ts, CloseableHttpClient httpClient, String url) throws IOException {
        MetricsUtils.sendMetric(null, metric, value, ts, httpClient, url);
    }

    public static void sendMetric(String splitting, String metric, int value, long ts, CloseableHttpClient httpClient, String url) throws IOException {
        MetricsUtils.sendDocument("{ \"timestamp\": " + ts + "," + (splitting != null ? "  \"splitting\": \"" + splitting + "\"," : "") + "  \"metric\": \"" + metric + "\",  \"value\": " + value + "}", httpClient, url);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void sendDocument(String json, CloseableHttpClient httpClient, String url) throws IOException {
        HttpPut httpPut = new HttpPut(url);
        httpPut.addHeader("Content-Type", "application/json");
        httpPut.setEntity((HttpEntity)new StringEntity(json, ContentType.APPLICATION_JSON));
        try (CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpPut);){
            HttpEntity entity = HttpClientWrapper.checkAndFetch((HttpResponse)response, url);
            try {
                log.info("Had result when sending document to Elasticsearch at " + url + ": " + IOUtils.toString((InputStream)entity.getContent(), (Charset)StandardCharsets.UTF_8));
            }
            finally {
                EntityUtils.consume((HttpEntity)entity);
            }
        }
    }
}

