/*
 * Decompiled with CFR 0.152.
 */
package org.dstadler.commons.logging.jdk;

import java.text.Format;
import java.text.MessageFormat;
import java.util.Date;
import java.util.Locale;
import java.util.logging.Formatter;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import org.apache.commons.lang3.time.FastDateFormat;

public class PatternFormatter
extends Formatter {
    private String logPattern;
    private String exceptionPattern;
    private String timeFormat;
    private MessageFormat logMessageFormat;
    private MessageFormat exceptionMessageFormat;
    private Format dateFormat;

    public PatternFormatter() {
        LogManager manager = LogManager.getLogManager();
        String cName = this.getClass().getName();
        this.timeFormat = manager.getProperty(cName + ".timeFormat");
        if (this.timeFormat == null) {
            this.timeFormat = "dd-MMM-yyy; HH:mm:ss";
        }
        this.setTimeFormat(this.timeFormat);
        this.logPattern = manager.getProperty(cName + ".logPattern");
        if (this.logPattern == null) {
            this.logPattern = "[{0} - {1}] {2}: {3} \n";
        }
        this.setLogPattern(this.logPattern);
        this.exceptionPattern = manager.getProperty(cName + ".exceptionPattern");
        if (this.exceptionPattern == null) {
            this.exceptionPattern = "[{0} - {1}] {2} {3} \nException in {4}: {6} \n{7} ";
        }
        this.setExceptionPattern(this.exceptionPattern);
        this.logMessageFormat = new MessageFormat(this.logPattern, Locale.ROOT);
        this.exceptionMessageFormat = new MessageFormat(this.exceptionPattern, Locale.ROOT);
        this.dateFormat = FastDateFormat.getInstance((String)this.timeFormat);
    }

    public final void setTimeFormat(String timeFormat) {
        this.timeFormat = timeFormat;
        this.dateFormat = FastDateFormat.getInstance((String)timeFormat);
    }

    public final void setLogPattern(String logFormatIn) {
        String logFormat = logFormatIn.replace("%LOGGER%", "{0}");
        logFormat = logFormat.replace("%LEVEL%", "{1}");
        logFormat = logFormat.replace("%TIME%", "{2}");
        logFormat = logFormat.replace("%MESSAGE%", "{3}");
        logFormat = logFormat.replace("%SOURCECLASS%", "{4}");
        this.logPattern = logFormat = logFormat.replace("%SOURCEMETHOD%", "{5}");
        this.logMessageFormat = new MessageFormat(this.logPattern, Locale.ROOT);
    }

    public final void setExceptionPattern(String exceptionFormatIn) {
        String exceptionFormat = exceptionFormatIn.replace("%LOGGER%", "{0}");
        exceptionFormat = exceptionFormat.replace("%LEVEL%", "{1}");
        exceptionFormat = exceptionFormat.replace("%TIME%", "{2}");
        exceptionFormat = exceptionFormat.replace("%MESSAGE%", "{3}");
        exceptionFormat = exceptionFormat.replace("%SOURCECLASS%", "{4}");
        exceptionFormat = exceptionFormat.replace("%SOURCEMETHOD%", "{5}");
        exceptionFormat = exceptionFormat.replace("%EXCEPTION%", "{6}");
        this.exceptionPattern = exceptionFormat = exceptionFormat.replace("%STACKTRACE%", "{7}");
        this.exceptionMessageFormat = new MessageFormat(this.logPattern, Locale.ROOT);
    }

    @Override
    public String format(LogRecord record) {
        String logMessage;
        Date time = new Date(record.getMillis());
        String formattedTime = this.dateFormat.format(time);
        if (record.getThrown() == null) {
            Object[] log = new Object[]{record.getLoggerName(), record.getLevel(), formattedTime, record.getMessage(), record.getSourceClassName(), record.getSourceMethodName()};
            logMessage = this.logMessageFormat.format(log);
        } else {
            String stack = this.getStackLayout(record.getThrown(), "");
            Object[] log = new Object[]{record.getLoggerName(), record.getLevel(), formattedTime, record.getMessage(), record.getSourceClassName(), record.getSourceMethodName(), record.getThrown().getMessage(), stack};
            logMessage = this.exceptionMessageFormat.format(log);
        }
        return logMessage;
    }

    private String getStackLayout(Throwable t, String indenterIn) {
        String indenter = indenterIn + " ";
        StackTraceElement[] ste = t.getStackTrace();
        StringBuilder stack = new StringBuilder(indenter).append(ste[0].toString());
        for (int i = 1; i < ste.length; ++i) {
            stack.append("\n").append(indenter).append(ste[i]);
        }
        String innerStack = "";
        if (t.getCause() != null) {
            innerStack = indenter + "Caused by: " + t.getCause().getMessage() + "\n";
            innerStack = innerStack + this.getStackLayout(t.getCause(), indenter);
        }
        stack.append("\n").append(innerStack);
        return stack.toString();
    }

    public String getExceptionPattern() {
        return this.exceptionPattern;
    }

    public String getLogPattern() {
        return this.logPattern;
    }

    public String getTimeFormat() {
        return this.timeFormat;
    }
}

