/*
 * Decompiled with CFR 0.152.
 */
package org.dstadler.commons.image;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import javax.imageio.ImageIO;

public class ImageUtils {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getTextAsPNG(String version) throws IOException {
        int height;
        int width;
        FontMetrics fm;
        BufferedImage img = new BufferedImage(1, 1, 2);
        Font font = new Font("Arial", 0, 14);
        Graphics2D g2d = img.createGraphics();
        try {
            g2d.setFont(font);
            fm = g2d.getFontMetrics();
            width = fm.stringWidth(version);
            height = fm.getHeight();
        }
        finally {
            g2d.dispose();
        }
        img = new BufferedImage(width, height, 2);
        g2d = img.createGraphics();
        try {
            g2d.setFont(font);
            fm = g2d.getFontMetrics();
            g2d.setColor(Color.BLACK);
            g2d.drawString(version, 0, fm.getAscent());
        }
        finally {
            g2d.dispose();
        }
        try (ByteArrayOutputStream stream = new ByteArrayOutputStream();){
            ImageIO.write((RenderedImage)img, "png", stream);
            stream.flush();
            byte[] byArray = stream.toByteArray();
            return byArray;
        }
    }
}

