/*
 * Decompiled with CFR 0.152.
 */
package org.dstadler.commons.http;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.HashSet;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.auth.AuthScheme;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.AuthCache;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.client.BasicAuthCache;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;
import org.dstadler.commons.http.HttpGetWithBody;
import org.dstadler.commons.logging.jdk.LoggerFactory;

public class HttpClientWrapper
implements Closeable {
    private static final Logger log = LoggerFactory.make();
    private final CloseableHttpClient httpClient;
    private final int timeoutMs;
    private final boolean withAuth;

    public HttpClientWrapper(String user, String password, int timeoutMs) {
        BasicCredentialsProvider credsProvider = new BasicCredentialsProvider();
        credsProvider.setCredentials(new AuthScope(null, -1), (Credentials)new UsernamePasswordCredentials(user, password));
        RequestConfig reqConfig = RequestConfig.custom().setSocketTimeout(timeoutMs).setConnectTimeout(timeoutMs).setConnectionRequestTimeout(timeoutMs).build();
        HttpClientBuilder builder = HttpClients.custom().setDefaultCredentialsProvider((CredentialsProvider)credsProvider).setDefaultRequestConfig(reqConfig);
        builder = this.createSSLSocketFactory(builder);
        this.httpClient = builder.build();
        this.timeoutMs = timeoutMs;
        this.withAuth = true;
    }

    public HttpClientWrapper(int timeoutMs) {
        RequestConfig reqConfig = RequestConfig.custom().setSocketTimeout(timeoutMs).setConnectTimeout(timeoutMs).setConnectionRequestTimeout(timeoutMs).build();
        HttpClientBuilder builder = HttpClients.custom().setDefaultRequestConfig(reqConfig);
        builder = this.createSSLSocketFactory(builder);
        this.httpClient = builder.build();
        this.timeoutMs = timeoutMs;
        this.withAuth = false;
    }

    public CloseableHttpClient getHttpClient() {
        return this.httpClient;
    }

    public String simpleGet(String url) throws IOException {
        AtomicReference str = new AtomicReference();
        this.simpleGetInternal(url, inputStream -> {
            try {
                str.set(IOUtils.toString((InputStream)inputStream, (Charset)StandardCharsets.UTF_8));
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }, null);
        return (String)str.get();
    }

    public String simpleGet(String url, String body) throws IOException {
        AtomicReference str = new AtomicReference();
        this.simpleGetInternal(url, inputStream -> {
            try {
                str.set(IOUtils.toString((InputStream)inputStream, (Charset)StandardCharsets.UTF_8));
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }, body);
        return (String)str.get();
    }

    public byte[] simpleGetBytes(String url) throws IOException {
        AtomicReference bytes = new AtomicReference();
        this.simpleGetInternal(url, inputStream -> {
            try {
                bytes.set(IOUtils.toByteArray((InputStream)inputStream));
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }, null);
        return (byte[])bytes.get();
    }

    public void simpleGet(String url, Consumer<InputStream> consumer) throws IOException {
        this.simpleGetInternal(url, consumer, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void simpleGetInternal(String url, Consumer<InputStream> consumer, String body) throws IOException {
        CloseableHttpResponse execute;
        Object httpGet;
        if (body == null) {
            httpGet = new HttpGet(url);
        } else {
            httpGet = new HttpGetWithBody(url);
            ((HttpGetWithBody)((Object)httpGet)).setEntity((HttpEntity)new StringEntity(body));
        }
        if (this.withAuth) {
            BasicAuthCache authCache = new BasicAuthCache();
            BasicScheme basicAuth = new BasicScheme();
            URL cacheUrl = new URL(url);
            HttpHost targetHost = new HttpHost(cacheUrl.getHost(), cacheUrl.getPort(), cacheUrl.getProtocol());
            authCache.put(targetHost, (AuthScheme)basicAuth);
            HttpClientContext context = HttpClientContext.create();
            context.setAuthCache((AuthCache)authCache);
            execute = this.httpClient.execute(targetHost, (HttpRequest)httpGet, (HttpContext)context);
        } else {
            execute = this.httpClient.execute((HttpUriRequest)httpGet);
        }
        try (CloseableHttpResponse response = execute;){
            HttpEntity entity = HttpClientWrapper.checkAndFetch((HttpResponse)response, url);
            try {
                consumer.accept(entity.getContent());
            }
            finally {
                EntityUtils.consume((HttpEntity)entity);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String simplePost(String url, String body) throws IOException {
        BasicAuthCache authCache = new BasicAuthCache();
        BasicScheme basicAuth = new BasicScheme();
        URL cacheUrl = new URL(url);
        HttpHost targetHost = new HttpHost(cacheUrl.getHost(), cacheUrl.getPort(), cacheUrl.getProtocol());
        authCache.put(targetHost, (AuthScheme)basicAuth);
        HttpClientContext context = HttpClientContext.create();
        context.setAuthCache((AuthCache)authCache);
        HttpPost httpPost = new HttpPost(url);
        if (body != null) {
            httpPost.setEntity((HttpEntity)new StringEntity(body));
        }
        try (CloseableHttpResponse response = this.httpClient.execute(targetHost, (HttpRequest)httpPost, (HttpContext)context);){
            String string;
            HttpEntity entity = HttpClientWrapper.checkAndFetch((HttpResponse)response, url);
            try {
                string = IOUtils.toString((InputStream)entity.getContent(), (Charset)StandardCharsets.UTF_8);
            }
            catch (Throwable throwable) {
                EntityUtils.consume((HttpEntity)entity);
                throw throwable;
            }
            EntityUtils.consume((HttpEntity)entity);
            return string;
        }
    }

    private HttpClientBuilder createSSLSocketFactory(HttpClientBuilder builder) {
        try {
            SSLContext sslcontext = SSLContext.getInstance("TLS");
            sslcontext.init(null, new TrustManager[]{new X509TrustManager(){

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return null;
                }

                @Override
                public void checkClientTrusted(X509Certificate[] certs, String authType) {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] certs, String authType) {
                }
            }}, new SecureRandom());
            SSLConnectionSocketFactory sslsf = new SSLConnectionSocketFactory(sslcontext, (HostnameVerifier)NoopHostnameVerifier.INSTANCE){

                protected void prepareSocket(SSLSocket socket) throws IOException {
                    super.prepareSocket(socket);
                    socket.setSoTimeout(HttpClientWrapper.this.timeoutMs);
                    HashSet<String> protocols = new HashSet<String>(Arrays.asList(socket.getEnabledProtocols()));
                    protocols.remove("SSLv2Hello");
                    socket.setEnabledProtocols(protocols.toArray(new String[0]));
                }
            };
            builder.setSSLSocketFactory((LayeredConnectionSocketFactory)sslsf);
        }
        catch (GeneralSecurityException e) {
            log.log(Level.WARNING, "Could not create SSLSocketFactory for accepting all certificates", e);
        }
        return builder;
    }

    @Override
    public void close() throws IOException {
        this.httpClient.close();
    }

    public static String retrieveData(String url) throws IOException {
        return HttpClientWrapper.retrieveData(url, "", null, 10000);
    }

    public static String retrieveData(String url, String user, String password, int timeoutMs) throws IOException {
        try (HttpClientWrapper wrapper = new HttpClientWrapper(user, password, timeoutMs);){
            String string = wrapper.simpleGet(url);
            return string;
        }
    }

    public static HttpEntity checkAndFetch(HttpResponse response, String url) throws IOException {
        int statusCode = response.getStatusLine().getStatusCode();
        if (statusCode > 206) {
            String msg = "Had HTTP StatusCode " + statusCode + " for request: " + url + ", response: " + response.getStatusLine().getReasonPhrase() + "\n" + (response.getEntity() == null ? "" : StringUtils.abbreviate((String)IOUtils.toString((InputStream)response.getEntity().getContent(), (Charset)StandardCharsets.UTF_8), (int)1024));
            log.warning(msg);
            throw new IOException(msg);
        }
        return response.getEntity();
    }

    public static void downloadFile(String url, File destination, int timeoutMs) throws IOException, IllegalStateException {
        log.info("Downloading from " + url + " to " + destination);
        try (HttpClientWrapper client = new HttpClientWrapper(timeoutMs);){
            client.simpleGet(url, (InputStream inputStream) -> {
                try {
                    FileUtils.copyInputStreamToFile((InputStream)inputStream, (File)destination);
                }
                catch (IOException e) {
                    throw new IllegalStateException(e);
                }
            });
        }
    }
}

