/*
 * Decompiled with CFR 0.152.
 */
package org.dstadler.commons.exec;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import java.util.logging.Logger;
import org.apache.commons.exec.CommandLine;
import org.apache.commons.exec.DefaultExecutor;
import org.apache.commons.exec.ExecuteException;
import org.apache.commons.exec.ExecuteStreamHandler;
import org.apache.commons.exec.ExecuteWatchdog;
import org.apache.commons.exec.Executor;
import org.apache.commons.exec.PumpStreamHandler;
import org.dstadler.commons.logging.jdk.LoggerFactory;

public class ExecutionHelper {
    private static final Logger log = LoggerFactory.make();

    public static InputStream getCommandResult(CommandLine cmdLine, File dir, int expectedExit, long timeout) throws IOException {
        return ExecutionHelper.getCommandResult(cmdLine, dir, expectedExit, timeout, null);
    }

    public static InputStream getCommandResult(CommandLine cmdLine, File dir, int expectedExit, long timeout, InputStream input) throws IOException {
        Executor executor = ExecutionHelper.getDefaultExecutor(dir, expectedExit, timeout);
        try (ByteArrayOutputStream outStr = new ByteArrayOutputStream();){
            executor.setStreamHandler((ExecuteStreamHandler)new PumpStreamHandler((OutputStream)outStr, (OutputStream)outStr, input));
            try {
                ExecutionHelper.execute(cmdLine, dir, executor, null);
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(outStr.toByteArray());
                return byteArrayInputStream;
            }
            catch (IOException e) {
                log.warning("Had output before error: " + new String(outStr.toByteArray()));
                throw new IOException(e);
            }
        }
    }

    public static void getCommandResultIntoStream(CommandLine cmdLine, File dir, int expectedExit, long timeout, OutputStream stream) throws IOException {
        ExecutionHelper.getCommandResultIntoStream(cmdLine, dir, expectedExit, timeout, stream, null);
    }

    public static void getCommandResultIntoStream(CommandLine cmdLine, File dir, int expectedExit, long timeout, OutputStream stream, Map<String, String> environment) throws IOException {
        Executor executor = ExecutionHelper.getDefaultExecutor(dir, expectedExit, timeout);
        executor.setStreamHandler((ExecuteStreamHandler)new PumpStreamHandler(stream));
        ExecutionHelper.execute(cmdLine, dir, executor, environment);
    }

    private static Executor getDefaultExecutor(File dir, int expectedExit, long timeout) {
        DefaultExecutor executor = new DefaultExecutor();
        if (expectedExit != -1) {
            executor.setExitValue(expectedExit);
        } else {
            executor.setExitValues(null);
        }
        ExecuteWatchdog watchdog = new ExecuteWatchdog(timeout);
        executor.setWatchdog(watchdog);
        executor.setWorkingDirectory(dir);
        return executor;
    }

    private static void execute(CommandLine cmdLine, File dir, Executor executor, Map<String, String> environment) throws IOException {
        log.info("-Executing(" + dir + "): " + cmdLine);
        try {
            int exitValue = executor.execute(cmdLine, environment);
            if (exitValue != 0) {
                log.info("Had exit code " + exitValue + " when calling " + cmdLine);
            }
        }
        catch (ExecuteException e) {
            throw new ExecuteException("While executing (" + dir + "); " + cmdLine, e.getExitValue(), (Throwable)e);
        }
    }
}

