/*
 * Decompiled with CFR 0.152.
 */
package org.dstadler.commons.date;

import java.text.ParseException;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.apache.commons.lang3.time.FastDateFormat;

public class DateParser {
    private static final TimeZone TIME_ZONE = TimeZone.getTimeZone("GMT+2");
    private static final Pattern RELATIVE_TIME_PATTERN = Pattern.compile("([0-9]+)(s|second|seconds|min|minute|minutes|h|hour|hours|d|day|days|w|week|weeks|mon|month|months|y|year|years)");
    private static final Map<String, Integer> UNIT_CONVERSION_TABLE = new HashMap<String, Integer>();
    private static FastDateFormat[] DATE_PARSERS;
    public static final long ONE_SECOND = 1000L;
    public static final long ONE_MINUTE = 60000L;
    public static final long ONE_HOUR = 3600000L;
    public static final long ONE_DAY = 86400000L;

    public static Date parseURLDate(String dateStr, Date defaultDate) {
        if (StringUtils.isEmpty((CharSequence)dateStr)) {
            return defaultDate;
        }
        if (dateStr.startsWith("-")) {
            String parse = dateStr.substring(1).toLowerCase();
            Matcher matcher = RELATIVE_TIME_PATTERN.matcher(parse);
            if (!matcher.matches()) {
                throw new IllegalArgumentException("Could not parse relative time value " + parse + ", expected to match " + RELATIVE_TIME_PATTERN);
            }
            String value = matcher.group(1);
            String unit = matcher.group(2);
            Integer factor = UNIT_CONVERSION_TABLE.get(unit);
            if (factor == null) {
                throw new IllegalArgumentException("Unknown unit: " + unit + " found while parsing relative time: " + parse);
            }
            return DateUtils.addSeconds((Date)new Date(), (int)(-1 * Integer.parseInt(value) * factor));
        }
        for (FastDateFormat format : DATE_PARSERS) {
            try {
                return format.parse(dateStr);
            }
            catch (ParseException factor) {
            }
        }
        StringBuilder string = new StringBuilder();
        for (FastDateFormat format : DATE_PARSERS) {
            string.append(format.getPattern()).append(", ");
        }
        throw new IllegalArgumentException("Could not parse absolute date " + dateStr + " via any of the available parsers: " + string.toString());
    }

    public static String computeTimeAgoString(long ts, String suffix) {
        long now = System.currentTimeMillis();
        DateParser.checkArgument(ts <= now, "Cannot handle timestamp in the future, now: " + now + "/" + new Date(now) + ", ts: " + ts + "/" + new Date(ts));
        long diff = now - ts;
        return DateParser.timeToReadable(diff, suffix);
    }

    public static String timeToReadable(long millis) {
        return DateParser.timeToReadable(millis, "");
    }

    public static String timeToReadable(long millis, String suffix) {
        StringBuilder builder = new StringBuilder();
        boolean haveDays = false;
        if (millis > 86400000L) {
            millis = DateParser.handleTime(builder, millis, 86400000L, "day", "s");
            haveDays = true;
        }
        boolean haveHours = false;
        if (millis >= 3600000L) {
            millis = DateParser.handleTime(builder, millis, 3600000L, "h", "");
            haveHours = true;
        }
        if (!(haveDays && haveHours || millis < 60000L)) {
            millis = DateParser.handleTime(builder, millis, 60000L, "min", "");
        }
        if (!haveDays && !haveHours && millis >= 1000L) {
            DateParser.handleTime(builder, millis, 1000L, "s", "");
        }
        if (builder.length() > 0) {
            builder.setLength(builder.length() - 2);
            builder.append(suffix);
        }
        return builder.toString();
    }

    private static long handleTime(StringBuilder builder, long diff, long amount, String type, String plural) {
        long days = diff / amount;
        builder.append(days).append(" ").append(type).append(days > 1L ? plural : "").append(", ");
        return diff -= days * amount;
    }

    public static void checkArgument(boolean expression, Object errorMessage) {
        if (!expression) {
            throw new IllegalArgumentException(String.valueOf(errorMessage));
        }
    }

    static {
        UNIT_CONVERSION_TABLE.put("s", 1);
        UNIT_CONVERSION_TABLE.put("second", 1);
        UNIT_CONVERSION_TABLE.put("seconds", 1);
        UNIT_CONVERSION_TABLE.put("min", 60);
        UNIT_CONVERSION_TABLE.put("minute", 60);
        UNIT_CONVERSION_TABLE.put("minutes", 60);
        UNIT_CONVERSION_TABLE.put("h", 3600);
        UNIT_CONVERSION_TABLE.put("hour", 3600);
        UNIT_CONVERSION_TABLE.put("hours", 3600);
        UNIT_CONVERSION_TABLE.put("d", 86400);
        UNIT_CONVERSION_TABLE.put("day", 86400);
        UNIT_CONVERSION_TABLE.put("days", 86400);
        UNIT_CONVERSION_TABLE.put("w", 604800);
        UNIT_CONVERSION_TABLE.put("week", 604800);
        UNIT_CONVERSION_TABLE.put("weeks", 604800);
        UNIT_CONVERSION_TABLE.put("mon", 2592000);
        UNIT_CONVERSION_TABLE.put("month", 2592000);
        UNIT_CONVERSION_TABLE.put("months", 2592000);
        UNIT_CONVERSION_TABLE.put("y", 31536000);
        UNIT_CONVERSION_TABLE.put("year", 31536000);
        UNIT_CONVERSION_TABLE.put("years", 31536000);
        DATE_PARSERS = new FastDateFormat[]{FastDateFormat.getInstance((String)"yyyy-MM-dd'T'HH:mm:ss.S", (TimeZone)TIME_ZONE, (Locale)Locale.GERMANY), FastDateFormat.getInstance((String)"yyyy-MM-dd", (TimeZone)TIME_ZONE), FastDateFormat.getInstance((String)"yyyyMMdd", (TimeZone)TIME_ZONE), FastDateFormat.getInstance((String)"HH:mm yyyyMMdd", (TimeZone)TIME_ZONE), FastDateFormat.getInstance((String)"HH:mm yyMMdd", (TimeZone)TIME_ZONE), FastDateFormat.getInstance((String)"MM/dd/yy", (TimeZone)TIME_ZONE)};
    }
}

