/*
 * Decompiled with CFR 0.152.
 */
package org.dstadler.commons.collections;

import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import org.dstadler.commons.collections.UnsupportedList;

public class ObjectAccessorList<R, E>
extends UnsupportedList<R> {
    private final List<E> original;
    private final Function<E, R> accessor;

    public ObjectAccessorList(List<E> original, Function<E, R> accessor) {
        this.original = original;
        this.accessor = accessor;
    }

    @Override
    public R get(int index) {
        return this.accessor.apply(this.original.get(index));
    }

    @Override
    public int size() {
        return this.original.size();
    }

    @Override
    public boolean isEmpty() {
        return this.original.isEmpty();
    }

    @Override
    public Iterator<R> iterator() {
        return new Iterator<R>(){
            private final Iterator<E> it;
            {
                this.it = ObjectAccessorList.this.original.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.it.hasNext();
            }

            @Override
            public R next() {
                return ObjectAccessorList.this.accessor.apply(this.it.next());
            }
        };
    }

    @Override
    public void forEach(Consumer<? super R> action) {
        this.original.forEach((? super T e) -> action.accept((R)this.accessor.apply(e)));
    }
}

