/*
 * Decompiled with CFR 0.152.
 */
package org.dstadler.commons.zip;

import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.dstadler.commons.io.DeleteOnCloseInputStream;
import org.dstadler.commons.zip.ZipFileCloseInputStream;

public class ZipUtils {
    private static final Logger logger = Logger.getLogger(ZipUtils.class.getName());
    private static final char ZIP_DELIMITER = '!';
    private static final String[] ZIP_EXTENSIONS = new String[]{".zip", ".jar", ".war", ".ear", ".aar", ".hpi", ".xlsx", ".docx", ".pptx"};

    public static boolean isZip(String fileName) {
        if (fileName == null) {
            return false;
        }
        String tl = fileName.toLowerCase();
        for (String element : ZIP_EXTENSIONS) {
            if (!tl.endsWith(element)) continue;
            return true;
        }
        return false;
    }

    public static boolean isFileInZip(String name) {
        if (name == null) {
            return false;
        }
        for (String element : ZIP_EXTENSIONS) {
            if (!name.toLowerCase().contains(element + '!')) continue;
            return true;
        }
        return false;
    }

    public static void findZip(String zipName, InputStream zipInput, FileFilter searchFilter, List<String> results) throws IOException {
        ZipInputStream zin = new ZipInputStream(zipInput);
        while (true) {
            ZipEntry en;
            try {
                en = zin.getNextEntry();
            }
            catch (IOException e) {
                throw new IOException("While handling file " + zipName, e);
            }
            catch (IllegalArgumentException e) {
                throw new IOException("While handling file " + zipName, e);
            }
            if (en == null) break;
            if (searchFilter.accept(new File(en.getName()))) {
                results.add(zipName + '!' + en);
            }
            if (!ZipUtils.isZip(en.getName())) continue;
            ZipUtils.findZip(zipName + '!' + en, zin, searchFilter, results);
        }
    }

    public static InputStream getZipContentsRecursive(String file) throws IOException {
        int pos = file.indexOf(33);
        if (pos == -1) {
            if (!new File(file).exists()) {
                throw new IOException("File " + file + " does not exist");
            }
            try {
                return new FileInputStream(file);
            }
            catch (IOException e) {
                if (e.getMessage().contains("because another process has locked")) {
                    logger.warning("Could not read file: " + file + " because it is locked.");
                    return new ByteArrayInputStream(new byte[0]);
                }
                throw e;
            }
        }
        String zip = file.substring(0, pos);
        String subfile = file.substring(pos + 1);
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Trying to read zipfile: " + zip + " subfile: " + subfile);
        }
        if (!(new File(zip).exists() && new File(zip).isFile() && new File(zip).canRead() && new File(zip).length() != 0L)) {
            throw new IOException("ZIP file: " + zip + " does not exist or is empty or not a readable file.");
        }
        ZipFile zipfile = new ZipFile(zip);
        pos = subfile.indexOf(33);
        if (pos != -1) {
            String remainder = subfile.substring(pos + 1);
            File subzipfile = File.createTempFile("ZipUtils", ".zip");
            try {
                ZipUtils.readToTemporaryFile(pos, zip, subfile, zipfile, subzipfile);
                DeleteOnCloseInputStream deleteOnCloseInputStream = new DeleteOnCloseInputStream(new ZipFileCloseInputStream(ZipUtils.getZipContentsRecursive(subzipfile.getAbsolutePath() + '!' + remainder), zipfile), subzipfile);
                return deleteOnCloseInputStream;
            }
            catch (IOException e) {
                zipfile.close();
                throw e;
            }
            finally {
                if (!subzipfile.delete()) {
                    logger.warning("Could not delete file " + subzipfile);
                }
            }
        }
        ZipEntry entry = zipfile.getEntry(subfile);
        return new ZipFileCloseInputStream(zipfile.getInputStream(entry), zipfile);
    }

    private static void readToTemporaryFile(int pos, String zip, String subfile, ZipFile zipfile, File subzipfile) throws IOException {
        ZipEntry entry = ZipUtils.openInnerZip(pos, zip, subfile, zipfile);
        try (InputStream zipstr = zipfile.getInputStream(entry);){
            FileUtils.copyInputStreamToFile((InputStream)zipstr, (File)subzipfile);
        }
    }

    private static ZipEntry openInnerZip(int pos, String zip, String subfile, ZipFile zipfile) throws IOException {
        String zipInner = subfile.substring(0, pos);
        ZipEntry entry = zipfile.getEntry(zipInner);
        if (entry == null) {
            throw new IOException("Could not read inner ZIP file: '" + zipInner + "' from ZIP file '" + zip + "'");
        }
        return entry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getZipStringContentsRecursive(String file) throws IOException {
        Throwable throwable;
        InputStream str;
        int pos = file.indexOf(33);
        if (pos == -1) {
            if (!new File(file).exists()) {
                throw new IOException("File " + file + " does not exist");
            }
            try (FileInputStream str2 = new FileInputStream(file);){
                if (((InputStream)str2).available() > 0) {
                    String string = IOUtils.toString((InputStream)str2);
                    return string;
                }
                String string = "";
                return string;
            }
            catch (IOException e) {
                if (!e.getMessage().contains("because another process has locked")) throw e;
                logger.warning("Could not read file: " + file + " because it is locked.");
                return "";
            }
        }
        String zip = file.substring(0, pos);
        String subfile = file.substring(pos + 1);
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Trying to read zipfile: " + zip + " subfile: " + subfile);
        }
        if (!new File(zip).exists()) throw new IOException("ZIP file: " + zip + " does not exist or is empty or not a readable file.");
        if (!new File(zip).isFile()) throw new IOException("ZIP file: " + zip + " does not exist or is empty or not a readable file.");
        if (!new File(zip).canRead()) throw new IOException("ZIP file: " + zip + " does not exist or is empty or not a readable file.");
        if (new File(zip).length() == 0L) {
            throw new IOException("ZIP file: " + zip + " does not exist or is empty or not a readable file.");
        }
        ZipFile zipfile = new ZipFile(zip);
        Throwable throwable2 = null;
        pos = subfile.indexOf(33);
        if (pos != -1) {
            String remainder = subfile.substring(pos + 1);
            File subzipfile = File.createTempFile("SearchZip", ".zip");
            try {
                ZipUtils.readToTemporaryFile(pos, zip, subfile, zipfile, subzipfile);
                String string = ZipUtils.getZipStringContentsRecursive(subzipfile.getAbsolutePath() + '!' + remainder);
                return string;
            }
            finally {
                if (!subzipfile.delete()) {
                    logger.warning("Could not delete file " + subzipfile);
                }
            }
        }
        ZipEntry entry = zipfile.getEntry(subfile);
        {
            catch (Throwable throwable3) {
                throwable2 = throwable3;
                throw throwable3;
            }
            str = zipfile.getInputStream(entry);
            throwable = null;
            try {
                if (str.available() > 0) {
                    String string = IOUtils.toString((InputStream)str);
                    return string;
                }
                String string = "";
                return string;
            }
            catch (Throwable throwable4) {}
            {
                throwable = throwable4;
                throw throwable4;
            }
        }
        finally {
            if (str != null) {
                if (throwable != null) {
                    try {
                        str.close();
                    }
                    catch (Throwable throwable5) {
                        throwable.addSuppressed(throwable5);
                    }
                } else {
                    str.close();
                }
            }
        }
        finally {
            if (zipfile != null) {
                if (throwable2 != null) {
                    try {
                        zipfile.close();
                    }
                    catch (Throwable throwable6) {
                        throwable2.addSuppressed(throwable6);
                    }
                } else {
                    zipfile.close();
                }
            }
        }
    }

    public static final void extractZip(File zip, File toDir) throws IOException {
        if (!toDir.exists()) {
            throw new IOException("Directory '" + toDir + "' does not exist.");
        }
        try (ZipFile zipFile = new ZipFile(zip);){
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                File target = new File(toDir, entry.getName());
                if (entry.isDirectory()) {
                    if (target.mkdirs()) continue;
                    logger.warning("Could not create directory " + target);
                    continue;
                }
                if (!target.getParentFile().exists() && !target.getParentFile().mkdirs()) {
                    logger.warning("Could not create directory " + target.getParentFile());
                }
                InputStream inputStream = zipFile.getInputStream(entry);
                Throwable throwable = null;
                try {
                    BufferedOutputStream outputStream = new BufferedOutputStream(new FileOutputStream(target));
                    Throwable throwable2 = null;
                    try {
                        IOUtils.copy((InputStream)inputStream, (OutputStream)outputStream);
                    }
                    catch (Throwable throwable3) {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    finally {
                        if (outputStream == null) continue;
                        if (throwable2 != null) {
                            try {
                                outputStream.close();
                            }
                            catch (Throwable throwable4) {
                                throwable2.addSuppressed(throwable4);
                            }
                            continue;
                        }
                        outputStream.close();
                    }
                }
                catch (Throwable throwable5) {
                    throwable = throwable5;
                    throw throwable5;
                }
                finally {
                    if (inputStream == null) continue;
                    if (throwable != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable6) {
                            throwable.addSuppressed(throwable6);
                        }
                        continue;
                    }
                    inputStream.close();
                }
            }
        }
        catch (FileNotFoundException e) {
            throw e;
        }
        catch (IOException e) {
            throw new IOException("While extracting file " + zip + " to " + toDir, e);
        }
    }

    public static final void extractZip(InputStream zip, final File toDir) throws IOException {
        if (!toDir.exists()) {
            throw new IOException("Directory '" + toDir + "' does not exist.");
        }
        new ZipFileVisitor(){

            @Override
            public void visit(ZipEntry entry, InputStream data) throws IOException {
                File target = new File(toDir, entry.getName());
                if (entry.isDirectory()) {
                    if (!target.mkdirs()) {
                        logger.warning("Could not create directory " + target);
                    }
                    return;
                }
                if (!target.getParentFile().exists() && !target.getParentFile().mkdirs()) {
                    logger.warning("Could not create directory " + target.getParentFile());
                }
                byte[] buffer = new byte[2048];
                try (BufferedOutputStream fout = new BufferedOutputStream(new FileOutputStream(target), buffer.length);){
                    int size;
                    while ((size = data.read(buffer, 0, buffer.length)) != -1) {
                        ((OutputStream)fout).write(buffer, 0, size);
                    }
                }
            }
        }.walk(zip);
    }

    public static void replaceInZip(String zipFile, String data, String encoding) throws IOException {
        if (zipFile == null || !ZipUtils.isFileInZip(zipFile)) {
            throw new IOException("Parameter should specify a file inside a ZIP file, but had: " + zipFile);
        }
        File zip = new File(zipFile.substring(0, zipFile.indexOf(33)));
        String zipOut = zipFile.substring(zipFile.indexOf(33) + 1);
        logger.info("Updating containing Zip " + zip + " to " + zipOut);
        ZipUtils.replaceInZip(zip, zipOut, data, encoding);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void replaceInZip(File zip, String file, String data, String encoding) throws IOException {
        File zipOutFile = File.createTempFile("ZipReplace", ".zip");
        try {
            block36: {
                FileOutputStream fos = new FileOutputStream(zipOutFile);
                try (ZipOutputStream zos = new ZipOutputStream(fos);
                     ZipFile zipFile = new ZipFile(zip);){
                    boolean found = false;
                    Enumeration<? extends ZipEntry> entries = zipFile.entries();
                    while (entries.hasMoreElements()) {
                        ZipEntry entry = entries.nextElement();
                        try {
                            if (entry.getName().equals(file)) {
                                zos.putNextEntry(new ZipEntry(entry.getName()));
                                IOUtils.write((String)data, (OutputStream)zos, (String)encoding);
                                found = true;
                                continue;
                            }
                            zos.putNextEntry(entry);
                            IOUtils.copy((InputStream)zipFile.getInputStream(entry), (OutputStream)zos);
                        }
                        finally {
                            zos.closeEntry();
                        }
                    }
                    if (found) break block36;
                    zos.putNextEntry(new ZipEntry(file));
                    try {
                        IOUtils.write((String)data, (OutputStream)zos);
                    }
                    finally {
                        zos.closeEntry();
                    }
                }
            }
            FileUtils.copyFile((File)zipOutFile, (File)zip);
        }
        finally {
            if (!zipOutFile.delete()) {
                throw new IOException("Error deleting file: " + zipOutFile);
            }
        }
    }

    public static abstract class ZipFileVisitor {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        public void walk(InputStream zipFile) throws IOException {
            block17: {
                stream = new ZipInputStream(zipFile);
                var3_3 = null;
                try {
                    while (true) lbl-1000:
                    // 3 sources

                    {
                        if ((entry = stream.getNextEntry()) == null) {
                            break block17;
                        }
                        try {
                            this.visit(entry, stream);
                        }
                        finally {
                            stream.closeEntry();
                            continue;
                        }
                        break;
                    }
                }
                catch (Throwable var4_6) {
                    var3_3 = var4_6;
                    throw var4_6;
                }
                finally {
                    if (stream != null) {
                        if (var3_3 != null) {
                            try {
                                stream.close();
                            }
                            catch (Throwable var4_5) {
                                var3_3.addSuppressed(var4_5);
                            }
                        } else {
                            stream.close();
                        }
                    }
                }
                ** GOTO lbl-1000
            }
        }

        public abstract void visit(ZipEntry var1, InputStream var2) throws IOException;
    }
}

