/*
 * Decompiled with CFR 0.152.
 */
package org.dstadler.commons.zip;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import org.apache.commons.io.input.CloseShieldInputStream;
import org.dstadler.commons.zip.OutputHandler;
import org.dstadler.commons.zip.ZipUtils;

public class ZipFileWalker {
    private final File zip;

    public ZipFileWalker(File file) {
        this.zip = file;
    }

    public boolean walk(OutputHandler outputHandler) throws IOException {
        try (ZipFile zipFile = new ZipFile(this.zip);){
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                File file = new File(this.zip, entry.getName());
                if (outputHandler.found(file, zipFile.getInputStream(entry))) {
                    boolean bl = true;
                    return bl;
                }
                if (!ZipUtils.isZip(entry.getName()) || !this.walkRecursive(file, zipFile.getInputStream(entry), outputHandler)) continue;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
    }

    private boolean walkRecursive(File base, InputStream stream, OutputHandler handler) throws IOException {
        ZipInputStream zipStream = new ZipInputStream(stream);
        while (true) {
            ZipEntry entry;
            try {
                entry = zipStream.getNextEntry();
            }
            catch (IOException e) {
                throw new IOException("While handling file: " + base, e);
            }
            if (entry == null) break;
            File file = new File(base, entry.getName());
            if (handler.found(file, (InputStream)new CloseShieldInputStream((InputStream)zipStream))) {
                return true;
            }
            if (ZipUtils.isZip(entry.getName()) && this.walkRecursive(file, zipStream, handler)) {
                return true;
            }
            zipStream.closeEntry();
        }
        return false;
    }
}

