/*
 * Decompiled with CFR 0.152.
 */
package org.dstadler.commons.exec;

import java.io.IOException;
import java.util.logging.Logger;
import org.apache.commons.exec.LogOutputStream;
import org.dstadler.commons.logging.jdk.LoggerFactory;

public final class BufferingLogOutputStream
extends LogOutputStream {
    private static final Logger log = LoggerFactory.make();
    private static final int LOG_FLUSH_LIMIT = 5000;
    private static final int LOG_FLUSH_TIME_LIMIT_SEC = 5;
    private final StringBuilder logBuffer = new StringBuilder();
    private long lastFlush = System.currentTimeMillis();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processLine(String line, int level) {
        StringBuilder stringBuilder = this.logBuffer;
        synchronized (stringBuilder) {
            if (line != null && line.length() > 0) {
                this.logBuffer.append(line).append("\n");
                if (this.logBuffer.length() > 5000 || this.lastFlush < System.currentTimeMillis() - 5000L) {
                    log.info(this.logBuffer.toString());
                    this.logBuffer.setLength(0);
                    this.lastFlush = System.currentTimeMillis();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        super.close();
        StringBuilder stringBuilder = this.logBuffer;
        synchronized (stringBuilder) {
            if (this.logBuffer.length() > 0) {
                log.info(this.logBuffer.toString());
                this.logBuffer.setLength(0);
                this.lastFlush = System.currentTimeMillis();
            }
        }
    }
}

