/*
 * Decompiled with CFR 0.152.
 */
package org.dstadler.commons.date;

import java.util.Calendar;
import java.util.GregorianCalendar;

public class DayCalendar
extends GregorianCalendar {
    private static final long serialVersionUID = -9054523308590467657L;
    public static final long MILLISECS_PER_MINUTE = 60000L;
    public static final long MILLISECS_PER_HOUR = 3600000L;
    protected static final long MILLISECS_PER_DAY = 86400000L;
    public static final long EPOCH_UNIX_ERA_DAY = 2440588L;

    public DayCalendar() {
    }

    public DayCalendar(long millisecondTime) {
        this.setTimeInMillis(millisecondTime);
    }

    public DayCalendar(int y, int m, int d) {
        super(y, m, d);
    }

    public DayCalendar(int y, int m, int d, int h, int min, int s) {
        super(y, m, d, h, min, s);
    }

    public long getUnixDay() {
        long offset = this.get(15) + this.get(16);
        return (long)Math.floor((double)(this.getTime().getTime() + offset) / 8.64E7);
    }

    public long getJulianDay() {
        return this.getUnixDay() + 2440588L;
    }

    public long diffDayPeriods(Calendar end) {
        long endL = end.getTimeInMillis() + (long)end.getTimeZone().getOffset(end.getTimeInMillis());
        long startL = this.getTimeInMillis() + (long)this.getTimeZone().getOffset(this.getTimeInMillis());
        return (endL - startL) / 86400000L;
    }
}

