/*
 * Decompiled with CFR 0.152.
 */
package org.dstadler.commons.collections;

import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.dstadler.commons.collections.MappedCounter;

public class MappedCounterImpl<T>
implements MappedCounter<T> {
    private Map<T, Integer> map = new HashMap<T, Integer>();

    @Override
    public void addInt(T k, int v) {
        if (!this.map.containsKey(k)) {
            this.map.put(k, v);
        } else {
            this.map.put(k, this.map.get(k) + v);
        }
    }

    @Override
    public void count(Collection<T> items) {
        for (T item : items) {
            this.addInt(item, 1);
        }
    }

    @Override
    public int get(T k) {
        return this.map.containsKey(k) ? this.map.get(k) : 0;
    }

    @Override
    public int remove(T key) {
        return this.map.remove(key);
    }

    @Override
    public Set<T> keys() {
        return this.map.keySet();
    }

    @Override
    public Set<Map.Entry<T, Integer>> entries() {
        return this.map.entrySet();
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    public Map<T, Integer> sortedMap() {
        LinkedList<Map.Entry<T, Integer>> list = new LinkedList<Map.Entry<T, Integer>>(this.map.entrySet());
        Collections.sort(list, new Comparator<Map.Entry<T, Integer>>(){

            @Override
            public int compare(Map.Entry<T, Integer> o1, Map.Entry<T, Integer> o2) {
                int ret = -1 * o1.getValue().compareTo(o2.getValue());
                if (ret != 0) {
                    return ret;
                }
                Object key1 = o1.getKey();
                Object key2 = o2.getKey();
                if (key1 == null && key2 == null) {
                    return 0;
                }
                if (key1 == null) {
                    return -1;
                }
                if (key2 == null) {
                    return 1;
                }
                return key1.toString().compareTo(key2.toString());
            }
        });
        LinkedHashMap result = new LinkedHashMap();
        for (Map.Entry entry : list) {
            result.put(entry.getKey(), entry.getValue());
        }
        return result;
    }

    @Override
    public int sum() {
        int sum = 0;
        for (Integer i : this.map.values()) {
            sum += i.intValue();
        }
        return sum;
    }

    @Override
    public String toString() {
        return this.map.toString();
    }
}

