/*
 * Decompiled with CFR 0.152.
 */
package org.dstadler.commons.logging.jdk;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.logging.FileHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import org.dstadler.commons.logging.jdk.DefaultFormatter;

public class LoggerFactory {
    protected LoggerFactory() {
    }

    public static Logger make() {
        Throwable t = new Throwable();
        StackTraceElement directCaller = t.getStackTrace()[1];
        return Logger.getLogger(directCaller.getClassName());
    }

    public static void initLogging() throws IOException {
        LoggerFactory.sendCommonsLogToJDKLog();
        try (InputStream resource = Thread.currentThread().getContextClassLoader().getResourceAsStream("logging.properties");){
            if (resource != null) {
                try {
                    LogManager.getLogManager().readConfiguration(resource);
                }
                finally {
                    resource.close();
                }
            }
            Logger log = Logger.getLogger("");
            for (Handler handler : log.getHandlers()) {
                handler.setFormatter(new DefaultFormatter());
            }
            if (resource == null) {
                throw new IOException("Did not find a file 'logging.properties' in the classpath");
            }
        }
    }

    public static void sendCommonsLogToJDKLog() {
        System.setProperty("org.apache.commons.logging.Log", "org.apache.commons.logging.impl.Jdk14Logger");
    }

    public static void rolloverLogfile() {
        Logger log = Logger.getLogger("");
        for (Handler handler : log.getHandlers()) {
            if (!(handler instanceof FileHandler)) continue;
            try {
                Method m = FileHandler.class.getDeclaredMethod("rotate", new Class[0]);
                m.setAccessible(true);
                if (Level.OFF.equals(handler.getLevel())) continue;
                m.invoke((Object)handler, new Object[0]);
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                throw new IllegalStateException(e);
            }
        }
    }
}

