/*
 * Decompiled with CFR 0.152.
 */
package org.dstadler.commons.logging.jdk;

import java.text.Format;
import java.util.Date;
import java.util.logging.Formatter;
import java.util.logging.LogRecord;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.FastDateFormat;

public class BriefLogFormatter
extends Formatter {
    private static final Format format = FastDateFormat.getInstance((String)"HH:mm:ss");
    private static final String lineSep = System.getProperty("line.separator");

    @Override
    public String format(LogRecord record) {
        String loggerName = record.getLoggerName();
        if (loggerName == null) {
            loggerName = "root";
        }
        StringBuilder output = new StringBuilder().append("[").append(StringUtils.repeat((String)" ", (int)(8 - record.getLevel().toString().length()))).append(record.getLevel()).append('|').append(StringUtils.repeat((String)" ", (int)(12 - Thread.currentThread().getName().length()))).append(Thread.currentThread().getName()).append('|').append(format.format(new Date(record.getMillis()))).append("]: ").append(record.getMessage()).append(' ').append(lineSep);
        return output.toString();
    }
}

