/*
 * Decompiled with CFR 0.152.
 */
package org.dstadler.commons.io;

import java.io.File;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Logger;

public class DeleteOnCloseInputStream
extends FilterInputStream {
    private static final Logger logger = Logger.getLogger(DeleteOnCloseInputStream.class.getName());
    private final File file;

    public DeleteOnCloseInputStream(InputStream stream, File file) {
        super(stream);
        if (stream == null) {
            throw new NullPointerException("Delegate stream was passed null");
        }
        this.file = file;
    }

    @Override
    public void close() throws IOException {
        super.close();
        if (!this.file.delete()) {
            logger.warning("Could not delete file: " + this.file);
        }
    }
}

