/*
 * Decompiled with CFR 0.152.
 */
package org.dstadler.commons.http;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.NoRouteToHostException;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.net.URLConnection;
import java.sql.Date;
import java.util.Random;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.dstadler.commons.http.IP;

public class Utils {
    private static final Logger logger = Logger.getLogger(Utils.class.toString());
    private static Random rand = new Random();

    public static void setSeed(long seed) {
        rand.setSeed(seed);
    }

    public static String getRandomURL() {
        int i2;
        int i1;
        StringBuilder str = new StringBuilder("http://");
        while ((i1 = rand.nextInt(256)) == 0 || i1 == 10 || i1 == 14 || i1 == 39 || i1 == 127 || i1 >= 224) {
        }
        str.append(i1);
        str.append('.');
        do {
            i2 = rand.nextInt(256);
        } while (i1 == 128 && i2 == 0 || i1 == 169 && i2 == 254 || i1 == 172 && i2 >= 16 && i2 <= 31 || i1 == 191 && i2 == 255 || i1 == 192 && i2 == 168 || i1 == 198 && i2 == 18 || i1 == 198 && i2 == 19);
        str.append(i2);
        str.append('.');
        str.append(rand.nextInt(256));
        str.append('.');
        str.append(rand.nextInt(256));
        str.append('/');
        return str.toString();
    }

    public static IP getRandomIP() {
        int i2;
        int i1;
        while ((i1 = rand.nextInt(256)) == 0 || i1 == 10 || i1 == 14 || i1 == 39 || i1 == 127 || i1 >= 224) {
        }
        do {
            i2 = rand.nextInt(256);
        } while (i1 == 128 && i2 == 0 || i1 == 169 && i2 == 254 || i1 == 172 && i2 >= 16 && i2 <= 31 || i1 == 191 && i2 == 255 || i1 == 192 && i2 == 168 || i1 == 198 && i2 == 18 || i1 == 198 && i2 == 19);
        return new IP(i1, i2, rand.nextInt(256), rand.nextInt(256));
    }

    public static boolean isIgnorableException(Exception e) {
        if (e instanceof NoRouteToHostException) {
            return true;
        }
        if (e instanceof SocketTimeoutException) {
            return true;
        }
        if (e.toString().contains("Connection timed out")) {
            return true;
        }
        if (e.toString().contains("Network is unreachable")) {
            return true;
        }
        if (e.toString().contains("Connection refused")) {
            return true;
        }
        if (e.toString().contains("Server returned HTTP response code: 403")) {
            return true;
        }
        return e.toString().contains("Server returned HTTP response code: 401");
    }

    public static boolean getURL(String sUrl, AtomicInteger gCount, long start) {
        URLConnection con;
        URL url;
        int count = gCount.incrementAndGet();
        if (count % 100 == 0) {
            long diff = (System.currentTimeMillis() - start) / 1000L;
            logger.info("Count: " + count + " IPS: " + (long)count / diff);
        }
        try {
            url = new URL(sUrl);
        }
        catch (MalformedURLException e) {
            logger.info("URL-Failed(" + count + "): " + e.toString());
            return false;
        }
        logger.log(Level.FINE, "Testing(" + count + "): " + url);
        try {
            con = url.openConnection();
            con.setConnectTimeout(10000);
            con.setReadTimeout(10000);
            con.getInputStream().read();
        }
        catch (IOException e) {
            if (Utils.isIgnorableException(e)) {
                return false;
            }
            logger.log(Level.WARNING, "Failed (" + url + ")(" + count + ")", e);
            return false;
        }
        logger.info("Last Modified (" + url + ")(" + count + "): " + new Date(con.getLastModified()));
        return true;
    }
}

