/*
 * Decompiled with CFR 0.152.
 */
package org.dstadler.commons.graphviz;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.exec.CommandLine;
import org.apache.commons.exec.DefaultExecutor;
import org.apache.commons.exec.ExecuteStreamHandler;
import org.apache.commons.exec.ExecuteWatchdog;
import org.apache.commons.exec.PumpStreamHandler;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;

public class DotUtils {
    public static String DOT_EXE = SystemUtils.IS_OS_WINDOWS ? "C:\\cygwin\\bin\\dot.exe" : "/usr/bin/dot";
    private static final String FOOTER = "}\n";

    public static void writeln(Writer writer, String string) throws IOException {
        DotUtils.writeln(writer, string, 0);
    }

    public static void writeln(Writer writer, String string, int indentLevel) throws IOException {
        writer.write(StringUtils.repeat((String)"\t", (int)indentLevel) + string);
        writer.write("\n");
    }

    public static void writeHeader(Writer writer, int dpi, String rankdir, String id, List<String> attribLines) throws IOException {
        attribLines = attribLines == null ? new ArrayList<String>() : new ArrayList<String>(attribLines);
        attribLines.add("node [shape=box];");
        String header = "digraph " + id + " {\n";
        if (dpi > 0) {
            header = header + "dpi=" + dpi + ";\n";
        }
        header = header + "rankdir=" + (StringUtils.isNotBlank((CharSequence)rankdir) ? rankdir : "LR") + ";\n";
        for (String line : attribLines) {
            line = line.trim();
            header = header + line + (line.endsWith(";") ? "\n" : ";\n");
        }
        DotUtils.writeln(writer, header);
    }

    public static void writeFooter(Writer writer) throws IOException {
        DotUtils.writeln(writer, FOOTER);
    }

    public static void renderGraph(File dotfile, File resultfile) throws IOException {
        CommandLine cmdLine = new CommandLine(DOT_EXE);
        cmdLine.addArgument("-T" + StringUtils.substringAfterLast((String)resultfile.getAbsolutePath(), (String)"."));
        cmdLine.addArgument(dotfile.getAbsolutePath());
        DefaultExecutor executor = new DefaultExecutor();
        executor.setExitValue(0);
        ExecuteWatchdog watchdog = new ExecuteWatchdog(60000L);
        executor.setWatchdog(watchdog);
        try (FileOutputStream out2 = new FileOutputStream(resultfile);){
            executor.setStreamHandler((ExecuteStreamHandler)new PumpStreamHandler((OutputStream)out2, (OutputStream)System.err));
            int exitValue = executor.execute(cmdLine);
            if (exitValue != 0) {
                throw new IOException("Could not convert graph to dot, had exit value: " + exitValue + "!");
            }
        }
        catch (IOException e) {
            resultfile.delete();
            throw e;
        }
    }

    public static boolean checkDot() throws IOException {
        CommandLine cmdLine = new CommandLine(DOT_EXE);
        cmdLine.addArgument("-V");
        DefaultExecutor executor = new DefaultExecutor();
        executor.setExitValue(0);
        ExecuteWatchdog watchdog = new ExecuteWatchdog(60000L);
        executor.setWatchdog(watchdog);
        executor.setStreamHandler((ExecuteStreamHandler)new PumpStreamHandler((OutputStream)System.out, (OutputStream)System.err));
        int exitValue = executor.execute(cmdLine);
        if (exitValue != 0) {
            System.err.println("Could not run '" + DOT_EXE + "', had exit value: " + exitValue + "!");
            return false;
        }
        return true;
    }

    public static void setDotExe(String dotExe) {
        DOT_EXE = dotExe;
    }
}

