/*
 * Decompiled with CFR 0.152.
 */
package org.dstadler.commons.exec;

import java.io.IOException;
import java.util.logging.Logger;
import org.apache.commons.exec.LogOutputStream;
import org.dstadler.commons.logging.jdk.LoggerFactory;

public final class BufferingLogOutputStream
extends LogOutputStream {
    private static final Logger log = LoggerFactory.make();
    private static final int LOG_FLUSH_LIMIT = 5000;
    private static final StringBuilder logBuffer = new StringBuilder();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processLine(String line, int level) {
        StringBuilder stringBuilder = logBuffer;
        synchronized (stringBuilder) {
            if (line != null && line.length() > 0) {
                logBuffer.append(line).append("\n");
                if (logBuffer.length() > 5000) {
                    log.info(logBuffer.toString());
                    logBuffer.setLength(0);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        super.close();
        StringBuilder stringBuilder = logBuffer;
        synchronized (stringBuilder) {
            if (logBuffer.length() > 0) {
                log.info(logBuffer.toString());
                logBuffer.setLength(0);
            }
        }
    }
}

