/*
 * Decompiled with CFR 0.152.
 */
package org.dstadler.commons.collections;

import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.dstadler.commons.collections.MappedCounter;

public class MappedCounterImpl<T>
implements MappedCounter<T> {
    private Map<T, Integer> map = new HashMap<T, Integer>();

    @Override
    public void addInt(T k, int v) {
        if (!this.map.containsKey(k)) {
            this.map.put(k, v);
        } else {
            this.map.put(k, this.map.get(k) + v);
        }
    }

    @Override
    public int get(T k) {
        return this.map.containsKey(k) ? this.map.get(k) : 0;
    }

    @Override
    public int remove(T key) {
        return this.map.remove(key);
    }

    @Override
    public Set<T> keys() {
        return this.map.keySet();
    }

    @Override
    public Set<Map.Entry<T, Integer>> entries() {
        return this.map.entrySet();
    }

    @Override
    public Map<T, Integer> sortedMap() {
        LinkedList<Map.Entry<T, Integer>> list = new LinkedList<Map.Entry<T, Integer>>(this.map.entrySet());
        Collections.sort(list, new Comparator<Map.Entry<T, Integer>>(){

            @Override
            public int compare(Map.Entry<T, Integer> o1, Map.Entry<T, Integer> o2) {
                int ret = -1 * o1.getValue().compareTo(o2.getValue());
                if (ret != 0) {
                    return ret;
                }
                return o1.getKey().toString().compareTo(o2.getKey().toString());
            }
        });
        LinkedHashMap result = new LinkedHashMap();
        for (Map.Entry entry : list) {
            result.put(entry.getKey(), entry.getValue());
        }
        return result;
    }

    @Override
    public int sum() {
        int sum = 0;
        for (Integer i : this.map.values()) {
            sum += i.intValue();
        }
        return sum;
    }

    @Override
    public String toString() {
        return this.map.toString();
    }
}

