/*
 * Decompiled with CFR 0.152.
 */
package org.dstadler.commons.collections;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;

public final class MapUtils {
    private MapUtils() {
    }

    public static <K, V extends Comparable<V>> List<Map.Entry<K, V>> sortByValue(Map<K, V> map) {
        ArrayList<Map.Entry<K, V>> entries = new ArrayList<Map.Entry<K, V>>(map.entrySet());
        Collections.sort(entries, new ByValue());
        return entries;
    }

    private static class ByValue<K, V extends Comparable<V>>
    implements Comparator<Map.Entry<K, V>>,
    Serializable {
        private static final long serialVersionUID = 1L;

        private ByValue() {
        }

        @Override
        public int compare(Map.Entry<K, V> o1, Map.Entry<K, V> o2) {
            return ((Comparable)o1.getValue()).compareTo(o2.getValue());
        }
    }
}

