/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.repository;

import gr.ekt.bte.core.TransformationEngine;
import gr.ekt.bte.core.TransformationSpec;
import gr.ekt.bte.exceptions.BadTransformationSpec;
import gr.ekt.bte.exceptions.MalformedSourceException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.app.rest.Parameter;
import org.dspace.app.rest.SearchRestMethod;
import org.dspace.app.rest.converter.WorkspaceItemConverter;
import org.dspace.app.rest.exception.DSpaceBadRequestException;
import org.dspace.app.rest.exception.RepositoryMethodNotImplementedException;
import org.dspace.app.rest.exception.UnprocessableEntityException;
import org.dspace.app.rest.model.ErrorRest;
import org.dspace.app.rest.model.WorkspaceItemRest;
import org.dspace.app.rest.model.patch.Operation;
import org.dspace.app.rest.model.patch.Patch;
import org.dspace.app.rest.repository.DSpaceRestRepository;
import org.dspace.app.rest.repository.ReloadableEntityObjectRepository;
import org.dspace.app.rest.repository.handler.service.UriListHandlerService;
import org.dspace.app.rest.submit.AbstractRestProcessingStep;
import org.dspace.app.rest.submit.SubmissionService;
import org.dspace.app.rest.submit.UploadableStep;
import org.dspace.app.rest.utils.Utils;
import org.dspace.app.util.SubmissionConfig;
import org.dspace.app.util.SubmissionConfigReader;
import org.dspace.app.util.SubmissionConfigReaderException;
import org.dspace.app.util.SubmissionStepConfig;
import org.dspace.authorize.AuthorizeException;
import org.dspace.authorize.service.AuthorizeService;
import org.dspace.content.Collection;
import org.dspace.content.DSpaceObject;
import org.dspace.content.InProgressSubmission;
import org.dspace.content.Item;
import org.dspace.content.WorkspaceItem;
import org.dspace.content.service.BitstreamFormatService;
import org.dspace.content.service.BitstreamService;
import org.dspace.content.service.CollectionService;
import org.dspace.content.service.ItemService;
import org.dspace.content.service.WorkspaceItemService;
import org.dspace.core.Context;
import org.dspace.eperson.EPerson;
import org.dspace.eperson.EPersonServiceImpl;
import org.dspace.event.Event;
import org.dspace.services.ConfigurationService;
import org.dspace.submit.AbstractProcessingStep;
import org.dspace.submit.lookup.DSpaceWorkspaceItemOutputGenerator;
import org.dspace.submit.lookup.MultipleSubmissionLookupDataLoader;
import org.dspace.submit.lookup.SubmissionItemDataLoader;
import org.dspace.submit.lookup.SubmissionLookupOutputGenerator;
import org.dspace.submit.lookup.SubmissionLookupService;
import org.dspace.submit.util.ItemSubmissionLookupDTO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.rest.webmvc.json.patch.PatchException;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Component;
import org.springframework.web.multipart.MultipartFile;

@Component(value="submission.workspaceitem")
public class WorkspaceItemRestRepository
extends DSpaceRestRepository<WorkspaceItemRest, Integer>
implements ReloadableEntityObjectRepository<WorkspaceItem, Integer> {
    public static final String OPERATION_PATH_SECTIONS = "sections";
    private static final Logger log = LogManager.getLogger(WorkspaceItemRestRepository.class);
    @Autowired
    WorkspaceItemService wis;
    @Autowired
    ItemService itemService;
    @Autowired
    BitstreamService bitstreamService;
    @Autowired
    BitstreamFormatService bitstreamFormatService;
    @Autowired
    ConfigurationService configurationService;
    @Autowired
    WorkspaceItemConverter workspaceItemConverter;
    @Autowired
    SubmissionService submissionService;
    @Autowired
    EPersonServiceImpl epersonService;
    @Autowired
    SubmissionLookupService submissionLookupService;
    @Autowired
    CollectionService collectionService;
    @Autowired
    AuthorizeService authorizeService;
    @Autowired
    private UriListHandlerService uriListHandlerService;
    private SubmissionConfigReader submissionConfigReader = new SubmissionConfigReader();

    @PreAuthorize(value="hasPermission(#id, 'WORKSPACEITEM', 'READ')")
    public WorkspaceItemRest findOne(Context context, Integer id) {
        WorkspaceItem witem = null;
        try {
            witem = this.wis.find(context, id.intValue());
        }
        catch (SQLException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        if (witem == null) {
            return null;
        }
        return (WorkspaceItemRest)this.converter.toRest((Object)witem, this.utils.obtainProjection());
    }

    @PreAuthorize(value="hasAuthority('ADMIN')")
    public Page<WorkspaceItemRest> findAll(Context context, Pageable pageable) {
        try {
            long total = this.wis.countTotal(context);
            List witems = this.wis.findAll(context, Integer.valueOf(pageable.getPageSize()), Integer.valueOf(Math.toIntExact(pageable.getOffset())));
            return this.converter.toRestPage(witems, pageable, total, this.utils.obtainProjection());
        }
        catch (SQLException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    @PreAuthorize(value="hasPermission(#submitterID, 'EPERSON', 'READ')")
    @SearchRestMethod(name="findBySubmitter")
    public Page<WorkspaceItemRest> findBySubmitter(@Parameter(value="uuid", required=true) UUID submitterID, Pageable pageable) {
        try {
            Context context = this.obtainContext();
            EPerson ep = this.epersonService.find(context, submitterID);
            long total = this.wis.countByEPerson(context, ep);
            List witems = this.wis.findByEPerson(context, ep, Integer.valueOf(pageable.getPageSize()), Integer.valueOf(Math.toIntExact(pageable.getOffset())));
            return this.converter.toRestPage(witems, pageable, total, this.utils.obtainProjection());
        }
        catch (SQLException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    protected WorkspaceItemRest createAndReturn(Context context) throws SQLException, AuthorizeException {
        WorkspaceItem source = this.submissionService.createWorkspaceItem(context, this.getRequestService().getCurrentRequest());
        return (WorkspaceItemRest)this.converter.toRest((Object)source, this.utils.obtainProjection());
    }

    protected WorkspaceItemRest save(Context context, WorkspaceItemRest wsi) {
        SubmissionConfig submissionConfig = this.submissionConfigReader.getSubmissionConfigByName(this.submissionConfigReader.getDefaultSubmissionConfigName());
        WorkspaceItem source = this.workspaceItemConverter.toModel(wsi);
        for (int stepNum = 0; stepNum < submissionConfig.getNumberOfSteps(); ++stepNum) {
            SubmissionStepConfig stepConfig = submissionConfig.getStep(stepNum);
            ClassLoader loader = this.getClass().getClassLoader();
            try {
                Class<?> stepClass = loader.loadClass(stepConfig.getProcessingClassName());
                Object stepInstance = stepClass.newInstance();
                if (!(stepInstance instanceof AbstractProcessingStep)) {
                    throw new Exception("The submission step class specified by '" + stepConfig.getProcessingClassName() + "' does not extend the class org.dspace.submit.AbstractProcessingStep! Therefore it cannot be used by the Configurable Submission as the <processing-class>!");
                }
                AbstractProcessingStep stepProcessing = (AbstractProcessingStep)stepClass.newInstance();
                stepProcessing.doPreProcessing(context, (InProgressSubmission)source);
                continue;
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
        this.submissionService.saveWorkspaceItem(context, source);
        return wsi;
    }

    public Class<WorkspaceItemRest> getDomainClass() {
        return WorkspaceItemRest.class;
    }

    @PreAuthorize(value="hasPermission(#id, 'WORKSPACEITEM', 'WRITE')")
    public WorkspaceItemRest upload(HttpServletRequest request, String apiCategory, String model, Integer id, MultipartFile file) throws SQLException {
        Context context = this.obtainContext();
        WorkspaceItemRest wsi = this.findOne(context, id);
        WorkspaceItem source = this.wis.find(context, id.intValue());
        ArrayList<ErrorRest> errors = new ArrayList<ErrorRest>();
        SubmissionConfig submissionConfig = this.submissionConfigReader.getSubmissionConfigByName(wsi.getSubmissionDefinition().getName());
        for (int i = 0; i < submissionConfig.getNumberOfSteps(); ++i) {
            SubmissionStepConfig stepConfig = submissionConfig.getStep(i);
            ClassLoader loader = this.getClass().getClassLoader();
            try {
                Class<?> stepClass = loader.loadClass(stepConfig.getProcessingClassName());
                Object stepInstance = stepClass.newInstance();
                if (!UploadableStep.class.isAssignableFrom(stepClass)) continue;
                UploadableStep uploadableStep = (UploadableStep)stepInstance;
                uploadableStep.doPreProcessing(context, (InProgressSubmission)source);
                ErrorRest err = uploadableStep.upload(context, this.submissionService, stepConfig, (InProgressSubmission)source, file);
                uploadableStep.doPostProcessing(context, (InProgressSubmission)source);
                if (err == null) continue;
                errors.add(err);
                continue;
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
        wsi = (WorkspaceItemRest)this.converter.toRest((Object)source, this.utils.obtainProjection());
        if (!errors.isEmpty()) {
            wsi.getErrors().addAll(errors);
        }
        context.commit();
        return wsi;
    }

    @PreAuthorize(value="hasPermission(#id, 'WORKSPACEITEM', 'WRITE')")
    public void patch(Context context, HttpServletRequest request, String apiCategory, String model, Integer id, Patch patch) throws SQLException, AuthorizeException {
        List operations = patch.getOperations();
        WorkspaceItemRest wsi = this.findOne(context, id);
        WorkspaceItem source = this.wis.find(context, id.intValue());
        for (Operation op : operations) {
            String[] path = op.getPath().substring(1).split("/", 3);
            if (OPERATION_PATH_SECTIONS.equals(path[0])) {
                String section = path[1];
                this.evaluatePatch(context, request, source, wsi, section, op);
                continue;
            }
            throw new DSpaceBadRequestException("Patch path operation need to starts with 'sections'");
        }
        this.wis.update(context, (InProgressSubmission)source);
    }

    private void evaluatePatch(Context context, HttpServletRequest request, WorkspaceItem source, WorkspaceItemRest wsi, String section, Operation op) {
        boolean sectionExist = false;
        SubmissionConfig submissionConfig = this.submissionConfigReader.getSubmissionConfigByName(wsi.getSubmissionDefinition().getName());
        for (int stepNum = 0; stepNum < submissionConfig.getNumberOfSteps(); ++stepNum) {
            SubmissionStepConfig stepConfig = submissionConfig.getStep(stepNum);
            if (!section.equals(stepConfig.getId())) continue;
            sectionExist = true;
            ClassLoader loader = this.getClass().getClassLoader();
            try {
                Class<?> stepClass = loader.loadClass(stepConfig.getProcessingClassName());
                Object stepInstance = stepClass.newInstance();
                if (!(stepInstance instanceof AbstractRestProcessingStep)) {
                    throw new DSpaceBadRequestException("The submission step class specified by '" + stepConfig.getProcessingClassName() + "' does not extend the class org.dspace.submit.AbstractProcessingStep! Therefore it cannot be used by the Configurable Submission as the <processing-class>!");
                }
                AbstractRestProcessingStep stepProcessing = (AbstractRestProcessingStep)stepClass.newInstance();
                stepProcessing.doPreProcessing(context, (InProgressSubmission)source);
                stepProcessing.doPatchProcessing(context, this.getRequestService().getCurrentRequest(), (InProgressSubmission)source, op, stepConfig);
                stepProcessing.doPostProcessing(context, (InProgressSubmission)source);
                continue;
            }
            catch (UnprocessableEntityException e) {
                throw e;
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
                throw new PatchException("Error processing the patch request", e);
            }
        }
        if (!sectionExist) {
            throw new UnprocessableEntityException("The section with name " + section + " does not exist in this submission!");
        }
    }

    @PreAuthorize(value="hasPermission(#id, 'WORKSPACEITEM', 'DELETE')")
    protected void delete(Context context, Integer id) throws AuthorizeException {
        WorkspaceItem witem = null;
        try {
            witem = this.wis.find(context, id.intValue());
            this.wis.deleteAll(context, witem);
            context.addEvent(new Event(32, 2, witem.getItem().getID(), null, this.itemService.getIdentifiers(context, (DSpaceObject)witem.getItem())));
        }
        catch (IOException | SQLException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterable<WorkspaceItemRest> upload(Context context, HttpServletRequest request, MultipartFile uploadfile) throws SQLException, FileNotFoundException, IOException, AuthorizeException {
        File file = Utils.getFile((MultipartFile)uploadfile, (String)"upload-loader", (String)"filedataloader");
        ArrayList<WorkspaceItemRest> results = new ArrayList<WorkspaceItemRest>();
        try {
            TransformationEngine transformationEngine2;
            String uuid = request.getParameter("collection");
            if (StringUtils.isBlank((CharSequence)uuid)) {
                uuid = this.configurationService.getProperty("submission.default.collection");
            }
            Collection collection = null;
            collection = StringUtils.isNotBlank((CharSequence)uuid) ? (Collection)this.collectionService.find(context, UUID.fromString(uuid)) : (Collection)this.collectionService.findAuthorizedOptimized(context, 3).get(0);
            SubmissionConfig submissionConfig = this.submissionConfigReader.getSubmissionConfigByCollection(collection.getHandle());
            ArrayList tmpResult = new ArrayList();
            TransformationEngine transformationEngine1 = this.submissionLookupService.getPhase1TransformationEngine();
            TransformationSpec spec = new TransformationSpec();
            spec.setNumberOfRecords(Integer.MAX_VALUE);
            if (transformationEngine1 != null) {
                MultipleSubmissionLookupDataLoader dataLoader = (MultipleSubmissionLookupDataLoader)transformationEngine1.getDataLoader();
                List fileDataLoaders = this.submissionLookupService.getFileProviders();
                for (String fileDataLoader : fileDataLoaders) {
                    dataLoader.setFile(file.getAbsolutePath(), fileDataLoader);
                    try {
                        SubmissionLookupOutputGenerator outputGenerator = (SubmissionLookupOutputGenerator)transformationEngine1.getOutputGenerator();
                        outputGenerator.setDtoList(new ArrayList());
                        log.debug("BTE transformation is about to start!");
                        transformationEngine1.transform(spec);
                        log.debug("BTE transformation finished!");
                        tmpResult.addAll(outputGenerator.getDtoList());
                        if (tmpResult.isEmpty()) continue;
                        break;
                    }
                    catch (BadTransformationSpec e1) {
                        log.error(e1.getMessage(), (Throwable)e1);
                    }
                    catch (MalformedSourceException e1) {
                        log.error(e1.getMessage(), (Throwable)e1);
                    }
                }
            }
            List<Object> result = null;
            if (!tmpResult.isEmpty() && (transformationEngine2 = this.submissionLookupService.getPhase2TransformationEngine()) != null) {
                SubmissionItemDataLoader dataLoader = (SubmissionItemDataLoader)transformationEngine2.getDataLoader();
                dataLoader.setDtoList(tmpResult);
                DSpaceWorkspaceItemOutputGenerator outputGenerator = (DSpaceWorkspaceItemOutputGenerator)transformationEngine2.getOutputGenerator();
                outputGenerator.setCollection(collection);
                outputGenerator.setContext(context);
                outputGenerator.setFormName(submissionConfig.getSubmissionName());
                outputGenerator.setDto((ItemSubmissionLookupDTO)tmpResult.get(0));
                try {
                    transformationEngine2.transform(spec);
                    result = outputGenerator.getWitems();
                }
                catch (BadTransformationSpec e1) {
                    e1.printStackTrace();
                }
                catch (MalformedSourceException e1) {
                    e1.printStackTrace();
                }
            }
            if (result == null) {
                WorkspaceItem source = this.submissionService.createWorkspaceItem(context, this.getRequestService().getCurrentRequest());
                result = new ArrayList<WorkspaceItem>();
                result.add(source);
            }
            if (result != null && !result.isEmpty()) {
                for (WorkspaceItem wi : result) {
                    ArrayList<ErrorRest> errors = new ArrayList<ErrorRest>();
                    if (result.size() == 1) {
                        for (int i = 0; i < submissionConfig.getNumberOfSteps(); ++i) {
                            SubmissionStepConfig stepConfig = submissionConfig.getStep(i);
                            ClassLoader loader = this.getClass().getClassLoader();
                            try {
                                UploadableStep uploadableStep;
                                ErrorRest err;
                                Class<?> stepClass = loader.loadClass(stepConfig.getProcessingClassName());
                                Object stepInstance = stepClass.newInstance();
                                if (!UploadableStep.class.isAssignableFrom(stepClass) || (err = (uploadableStep = (UploadableStep)stepInstance).upload(context, this.submissionService, stepConfig, (InProgressSubmission)wi, uploadfile)) == null) continue;
                                errors.add(err);
                                continue;
                            }
                            catch (Exception e) {
                                log.error(e.getMessage(), (Throwable)e);
                            }
                        }
                    }
                    WorkspaceItemRest wsi = (WorkspaceItemRest)this.converter.toRest((Object)wi, this.utils.obtainProjection());
                    if (result.size() == 1 && !errors.isEmpty()) {
                        wsi.getErrors().addAll(errors);
                    }
                    results.add(wsi);
                }
            }
        }
        finally {
            file.delete();
        }
        return results;
    }

    protected WorkspaceItemRest createAndReturn(Context context, List<String> stringList) throws AuthorizeException, SQLException, RepositoryMethodNotImplementedException {
        HttpServletRequest req = this.getRequestService().getCurrentRequest().getHttpServletRequest();
        WorkspaceItem workspaceItem = (WorkspaceItem)this.uriListHandlerService.handle(context, req, stringList, WorkspaceItem.class);
        return (WorkspaceItemRest)this.converter.toRest((Object)workspaceItem, this.utils.obtainProjection());
    }

    @SearchRestMethod(name="item")
    public WorkspaceItemRest findByItemUuid(@Parameter(value="uuid", required=true) UUID itemUuid, Pageable pageable) {
        try {
            Context context = this.obtainContext();
            Item item = (Item)this.itemService.find(context, itemUuid);
            WorkspaceItem workspaceItem = this.wis.findByItem(context, item);
            if (workspaceItem == null) {
                return null;
            }
            if (!this.authorizeService.authorizeActionBoolean(context, (DSpaceObject)workspaceItem.getItem(), 0)) {
                throw new AccessDeniedException("The current user does not have rights to view the WorkflowItem");
            }
            return (WorkspaceItemRest)this.converter.toRest((Object)workspaceItem, this.utils.obtainProjection());
        }
        catch (SQLException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public WorkspaceItem findDomainObjectByPk(Context context, Integer id) throws SQLException {
        return this.wis.find(context, id.intValue());
    }

    public Class<Integer> getPKClass() {
        return Integer.class;
    }
}

