/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.repository;

import java.io.IOException;
import java.sql.SQLException;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.log4j.Logger;
import org.dspace.app.rest.converter.ConverterService;
import org.dspace.app.rest.exception.RepositoryMethodNotImplementedException;
import org.dspace.app.rest.model.BitstreamRest;
import org.dspace.app.rest.model.ProcessRest;
import org.dspace.app.rest.projection.Projection;
import org.dspace.app.rest.repository.DSpaceRestRepository;
import org.dspace.authorize.AuthorizeException;
import org.dspace.authorize.service.AuthorizeService;
import org.dspace.content.Bitstream;
import org.dspace.core.Context;
import org.dspace.scripts.Process;
import org.dspace.scripts.service.ProcessService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.rest.webmvc.ResourceNotFoundException;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Component;

@Component(value="system.process")
public class ProcessRestRepository
extends DSpaceRestRepository<ProcessRest, Integer> {
    private static final Logger log = Logger.getLogger(ProcessRestRepository.class);
    @Autowired
    private ProcessService processService;
    @Autowired
    private ConverterService converterService;
    @Autowired
    private AuthorizeService authorizeService;

    @PreAuthorize(value="hasPermission(#id, 'PROCESS', 'READ')")
    public ProcessRest findOne(Context context, Integer id) {
        try {
            Process process = this.processService.find(context, id.intValue());
            if (process == null) {
                return null;
            }
            return (ProcessRest)this.converter.toRest((Object)process, this.utils.obtainProjection());
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    @PreAuthorize(value="hasAuthority('ADMIN')")
    public Page<ProcessRest> findAll(Context context, Pageable pageable) {
        try {
            int total = this.processService.countTotal(context);
            List processes = this.processService.findAll(context, pageable.getPageSize(), Math.toIntExact(pageable.getOffset()));
            return this.converter.toRestPage(processes, pageable, (long)total, this.utils.obtainProjection());
        }
        catch (SQLException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public List<BitstreamRest> getProcessBitstreams(Integer processId) throws SQLException, AuthorizeException {
        Context context = this.obtainContext();
        Process process = this.getProcess(processId, context);
        List bitstreams = this.processService.getBitstreams(context, process);
        return bitstreams.stream().map(bitstream -> (BitstreamRest)this.converterService.toRest(bitstream, Projection.DEFAULT)).collect(Collectors.toList());
    }

    private Process getProcess(Integer processId, Context context) throws SQLException, AuthorizeException {
        Process process = this.processService.find(context, processId.intValue());
        if (process == null) {
            throw new ResourceNotFoundException("Process with id " + processId + " was not found");
        }
        if (context.getCurrentUser() == null || !context.getCurrentUser().equals((Object)process.getEPerson()) && !this.authorizeService.isAdmin(context)) {
            throw new AuthorizeException("The current user is not eligible to view the process with id: " + processId);
        }
        return process;
    }

    public BitstreamRest getProcessBitstreamByType(Integer processId, String type) throws SQLException, AuthorizeException {
        Context context = this.obtainContext();
        Process process = this.getProcess(processId, context);
        Bitstream bitstream = this.processService.getBitstream(context, process, type);
        return (BitstreamRest)this.converterService.toRest((Object)bitstream, this.utils.obtainProjection());
    }

    protected void delete(Context context, Integer integer) throws AuthorizeException, RepositoryMethodNotImplementedException {
        try {
            this.processService.delete(context, this.processService.find(context, integer.intValue()));
        }
        catch (IOException | SQLException e) {
            log.error((Object)("Something went wrong trying to find Process with id: " + integer), (Throwable)e);
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public Class<ProcessRest> getDomainClass() {
        return ProcessRest.class;
    }
}

