/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.repository;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Set;
import org.dspace.app.rest.DiscoverableEndpointsService;
import org.dspace.app.rest.model.AuthorityRest;
import org.dspace.app.rest.projection.Projection;
import org.dspace.app.rest.repository.DSpaceRestRepository;
import org.dspace.app.rest.utils.AuthorityUtils;
import org.dspace.content.authority.ChoiceAuthority;
import org.dspace.content.authority.service.ChoiceAuthorityService;
import org.dspace.core.Context;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.hateoas.Link;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Component;

@Component(value="integration.authority")
public class AuthorityRestRepository
extends DSpaceRestRepository<AuthorityRest, String>
implements InitializingBean {
    @Autowired
    private ChoiceAuthorityService cas;
    @Autowired
    private AuthorityUtils authorityUtils;
    @Autowired
    DiscoverableEndpointsService discoverableEndpointsService;

    @PreAuthorize(value="hasAuthority('AUTHENTICATED')")
    public AuthorityRest findOne(Context context, String name) {
        ChoiceAuthority source = this.cas.getChoiceAuthorityByAuthorityName(name);
        return this.authorityUtils.convertAuthority(source, name, this.utils.obtainProjection());
    }

    @PreAuthorize(value="hasAuthority('AUTHENTICATED')")
    public Page<AuthorityRest> findAll(Context context, Pageable pageable) {
        Set authoritiesName = this.cas.getChoiceAuthoritiesNames();
        ArrayList<AuthorityRest> results = new ArrayList<AuthorityRest>();
        Projection projection = this.utils.obtainProjection();
        for (String authorityName : authoritiesName) {
            ChoiceAuthority source = this.cas.getChoiceAuthorityByAuthorityName(authorityName);
            AuthorityRest result = this.authorityUtils.convertAuthority(source, authorityName, projection);
            results.add(result);
        }
        return new PageImpl(results, pageable, (long)results.size());
    }

    public Class<AuthorityRest> getDomainClass() {
        return AuthorityRest.class;
    }

    public void afterPropertiesSet() throws Exception {
        this.discoverableEndpointsService.register((Object)this, Arrays.asList(new Link("/api/authz/authorization/search", "authorization-search")));
    }
}

