/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.submit.step;

import gr.ekt.bte.core.Record;
import gr.ekt.bte.core.RecordSet;
import gr.ekt.bte.dataloader.FileDataLoader;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.app.rest.model.ErrorRest;
import org.dspace.app.rest.submit.SubmissionService;
import org.dspace.app.rest.submit.UploadableStep;
import org.dspace.app.rest.utils.Utils;
import org.dspace.app.util.SubmissionStepConfig;
import org.dspace.content.InProgressSubmission;
import org.dspace.content.Item;
import org.dspace.core.Context;
import org.dspace.services.factory.DSpaceServicesFactory;
import org.dspace.submit.extraction.MetadataExtractor;
import org.dspace.submit.step.ExtractionStep;
import org.springframework.web.multipart.MultipartFile;

public class ExtractMetadataStep
extends ExtractionStep
implements UploadableStep {
    private static final Logger log = LogManager.getLogger(ExtractMetadataStep.class);

    @Override
    public ErrorRest upload(Context context, SubmissionService submissionService, SubmissionStepConfig stepConfig, InProgressSubmission wsi, MultipartFile multipartFile) throws IOException {
        Item item = wsi.getItem();
        try {
            List extractors = DSpaceServicesFactory.getInstance().getServiceManager().getServicesByType(MetadataExtractor.class);
            File file = null;
            for (MetadataExtractor extractor : extractors) {
                FileDataLoader dataLoader = extractor.getDataLoader();
                RecordSet recordSet = null;
                if (!extractor.getExtensions().contains(FilenameUtils.getExtension((String)multipartFile.getOriginalFilename()))) continue;
                if (file == null) {
                    file = Utils.getFile(multipartFile, "submissionlookup-loader", stepConfig.getId());
                }
                FileDataLoader fdl = dataLoader;
                fdl.setFilename(Utils.getFileName(multipartFile));
                recordSet = this.convertFields(dataLoader.getRecords(), this.bteBatchImportService.getOutputMap());
                this.enrichItem(context, recordSet.getRecords(), item);
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            ErrorRest result = new ErrorRest();
            result.setMessage(e.getMessage());
            result.getPaths().add("/sections/" + stepConfig.getId());
            return result;
        }
        return null;
    }

    private RecordSet convertFields(RecordSet recordSet, Map<String, String> fieldMap) {
        RecordSet result = new RecordSet();
        for (Record publication : recordSet.getRecords()) {
            for (String fieldName : fieldMap.keySet()) {
                String md = null;
                if (fieldMap != null) {
                    md = fieldMap.get(fieldName);
                }
                if (StringUtils.isBlank(md)) continue;
                md = md.trim();
                if (!publication.isMutable()) continue;
                List values = publication.getValues(md);
                publication.makeMutable().removeField(md);
                publication.makeMutable().addField(fieldName, values);
            }
            result.addRecord(publication);
        }
        return result;
    }
}

