/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.repository;

import java.sql.SQLException;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;
import javax.servlet.http.HttpServletRequest;
import org.dspace.app.rest.model.WorkflowStepRest;
import org.dspace.app.rest.projection.Projection;
import org.dspace.app.rest.repository.AbstractDSpaceRestRepository;
import org.dspace.app.rest.repository.LinkRestRepository;
import org.dspace.core.Context;
import org.dspace.xmlworkflow.factory.XmlWorkflowFactory;
import org.dspace.xmlworkflow.storedcomponents.ClaimedTask;
import org.dspace.xmlworkflow.storedcomponents.PoolTask;
import org.dspace.xmlworkflow.storedcomponents.XmlWorkflowItem;
import org.dspace.xmlworkflow.storedcomponents.service.ClaimedTaskService;
import org.dspace.xmlworkflow.storedcomponents.service.PoolTaskService;
import org.dspace.xmlworkflow.storedcomponents.service.XmlWorkflowItemService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.rest.webmvc.ResourceNotFoundException;
import org.springframework.stereotype.Component;

@Component(value="workflow.workflowitem.step")
public class WorkflowItemStepLinkRepository
extends AbstractDSpaceRestRepository
implements LinkRestRepository {
    @Autowired
    private XmlWorkflowItemService xmlWorkflowItemService;
    @Autowired
    private PoolTaskService poolTaskService;
    @Autowired
    private ClaimedTaskService claimedTaskService;
    @Autowired
    private XmlWorkflowFactory xmlWorkflowFactory;

    public WorkflowStepRest getStep(@Nullable HttpServletRequest request, Integer workflowItemId, @Nullable Pageable optionalPageable, Projection projection) {
        Context context = this.obtainContext();
        try {
            XmlWorkflowItem xmlWorkflowItem = (XmlWorkflowItem)this.xmlWorkflowItemService.find(context, workflowItemId.intValue());
            if (xmlWorkflowItem == null) {
                throw new ResourceNotFoundException("XmlWorkflowItem with id: " + workflowItemId + " wasn't found");
            }
            List poolTasks = this.poolTaskService.find(context, xmlWorkflowItem);
            List claimedTasks = this.claimedTaskService.find(context, xmlWorkflowItem);
            Iterator iterator = poolTasks.iterator();
            if (iterator.hasNext()) {
                PoolTask poolTask = (PoolTask)iterator.next();
                return (WorkflowStepRest)this.converter.toRest(this.xmlWorkflowFactory.getStepByName(poolTask.getStepID()), projection);
            }
            iterator = claimedTasks.iterator();
            if (iterator.hasNext()) {
                ClaimedTask claimedTask = (ClaimedTask)iterator.next();
                return (WorkflowStepRest)this.converter.toRest(this.xmlWorkflowFactory.getStepByName(claimedTask.getStepID()), projection);
            }
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        throw new ResourceNotFoundException("No workflowStep for this workflowItem with id: " + workflowItemId + " was found");
    }
}

