/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.repository;

import java.util.List;
import org.dspace.app.rest.model.SubmissionFormRest;
import org.dspace.app.rest.repository.DSpaceRestRepository;
import org.dspace.app.util.DCInputSet;
import org.dspace.app.util.DCInputsReader;
import org.dspace.app.util.DCInputsReaderException;
import org.dspace.core.Context;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Component;

@Component(value="config.submissionform")
public class SubmissionFormRestRepository
extends DSpaceRestRepository<SubmissionFormRest, String> {
    private DCInputsReader inputReader = new DCInputsReader();

    @Override
    @PreAuthorize(value="hasAuthority('AUTHENTICATED')")
    public SubmissionFormRest findOne(Context context, String submitName) {
        DCInputSet inputConfig;
        try {
            inputConfig = this.inputReader.getInputsByFormName(submitName);
        }
        catch (DCInputsReaderException e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
        if (inputConfig == null) {
            return null;
        }
        return (SubmissionFormRest)this.converter.toRest(inputConfig, this.utils.obtainProjection());
    }

    @Override
    @PreAuthorize(value="hasAuthority('AUTHENTICATED')")
    public Page<SubmissionFormRest> findAll(Context context, Pageable pageable) {
        try {
            long total = this.inputReader.countInputs();
            List subConfs = this.inputReader.getAllInputs(Integer.valueOf(pageable.getPageSize()), Integer.valueOf(Math.toIntExact(pageable.getOffset())));
            return this.converter.toRestPage(subConfs, pageable, total, this.utils.obtainProjection());
        }
        catch (DCInputsReaderException e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    @Override
    public Class<SubmissionFormRest> getDomainClass() {
        return SubmissionFormRest.class;
    }
}

