/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.converter;

import org.dspace.app.rest.converter.ConverterService;
import org.dspace.app.rest.converter.DSpaceConverter;
import org.dspace.app.rest.model.EntityTypeRest;
import org.dspace.app.rest.model.RelationshipTypeRest;
import org.dspace.app.rest.projection.Projection;
import org.dspace.content.RelationshipType;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class RelationshipTypeConverter
implements DSpaceConverter<RelationshipType, RelationshipTypeRest> {
    @Autowired
    private ConverterService converter;

    @Override
    public RelationshipTypeRest convert(RelationshipType obj, Projection projection) {
        RelationshipTypeRest relationshipTypeRest = new RelationshipTypeRest();
        relationshipTypeRest.setProjection(projection);
        relationshipTypeRest.setId(obj.getID());
        relationshipTypeRest.setLeftwardType(obj.getLeftwardType());
        relationshipTypeRest.setRightwardType(obj.getRightwardType());
        relationshipTypeRest.setCopyToLeft(obj.isCopyToLeft());
        relationshipTypeRest.setCopyToRight(obj.isCopyToRight());
        relationshipTypeRest.setLeftMinCardinality(obj.getLeftMinCardinality());
        relationshipTypeRest.setLeftMaxCardinality(obj.getLeftMaxCardinality());
        relationshipTypeRest.setRightMinCardinality(obj.getRightMinCardinality());
        relationshipTypeRest.setRightMaxCardinality(obj.getRightMaxCardinality());
        relationshipTypeRest.setLeftType((EntityTypeRest)this.converter.toRest(obj.getLeftType(), projection));
        relationshipTypeRest.setRightType((EntityTypeRest)this.converter.toRest(obj.getRightType(), projection));
        return relationshipTypeRest;
    }

    @Override
    public Class<RelationshipType> getModelClass() {
        return RelationshipType.class;
    }
}

