/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.converter;

import java.util.Collection;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.dspace.app.rest.converter.DiscoverFacetValueConverter;
import org.dspace.app.rest.converter.SearchFilterToAppliedFilterConverter;
import org.dspace.app.rest.model.FacetResultsRest;
import org.dspace.app.rest.model.SearchFacetEntryRest;
import org.dspace.app.rest.model.SearchFacetValueRest;
import org.dspace.app.rest.model.SearchResultsRest;
import org.dspace.app.rest.parameter.SearchFilter;
import org.dspace.app.rest.projection.Projection;
import org.dspace.core.Context;
import org.dspace.discovery.DiscoverResult;
import org.dspace.discovery.configuration.DiscoveryConfiguration;
import org.dspace.discovery.configuration.DiscoverySearchFilterFacet;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

@Component
public class DiscoverFacetResultsConverter {
    @Autowired
    private DiscoverFacetValueConverter facetValueConverter;
    @Autowired
    private SearchFilterToAppliedFilterConverter searchFilterToAppliedFilterConverter;

    public FacetResultsRest convert(Context context, String facetName, String prefix, String query, String dsoType, String dsoScope, List<SearchFilter> searchFilters, DiscoverResult searchResult, DiscoveryConfiguration configuration, Pageable page, Projection projection) {
        FacetResultsRest facetResultsRest = new FacetResultsRest();
        facetResultsRest.setProjection(projection);
        this.setRequestInformation(context, facetName, prefix, query, dsoType, dsoScope, searchFilters, searchResult, configuration, facetResultsRest, page, projection);
        this.addToFacetResultList(facetName, searchResult, facetResultsRest, configuration, page, projection);
        return facetResultsRest;
    }

    private void addToFacetResultList(String facetName, DiscoverResult searchResult, FacetResultsRest facetResultsRest, DiscoveryConfiguration configuration, Pageable page, Projection projection) {
        DiscoverySearchFilterFacet field = configuration.getSidebarFacet(facetName);
        List facetValues = searchResult.getFacetResult(field);
        int valueCount = 0;
        for (DiscoverResult.FacetResult value : CollectionUtils.emptyIfNull((Collection)facetValues)) {
            if (valueCount >= page.getPageSize()) break;
            SearchFacetValueRest searchFacetValueRest = this.buildSearchFacetValueRestFromFacetResult(value, projection);
            facetResultsRest.addToFacetResultList(searchFacetValueRest);
            ++valueCount;
        }
    }

    private SearchFacetValueRest buildSearchFacetValueRestFromFacetResult(DiscoverResult.FacetResult value, Projection projection) {
        return this.facetValueConverter.convert(value, projection);
    }

    private void setRequestInformation(Context context, String facetName, String prefix, String query, String dsoType, String dsoScope, List<SearchFilter> searchFilters, DiscoverResult searchResult, DiscoveryConfiguration configuration, FacetResultsRest facetResultsRest, Pageable page, Projection projection) {
        facetResultsRest.setQuery(query);
        facetResultsRest.setPrefix(prefix);
        facetResultsRest.setScope(dsoScope);
        facetResultsRest.setDsoType(dsoType);
        facetResultsRest.setFacetEntry(this.convertFacetEntry(facetName, searchResult, configuration, page, projection));
        facetResultsRest.setSort(SearchResultsRest.Sorting.fromPage(page));
        facetResultsRest.setSearchFilters(searchFilters);
        for (SearchFilter searchFilter : CollectionUtils.emptyIfNull(searchFilters)) {
            facetResultsRest.addAppliedFilter(this.searchFilterToAppliedFilterConverter.convertSearchFilter(context, searchFilter));
        }
    }

    private SearchFacetEntryRest convertFacetEntry(String facetName, DiscoverResult searchResult, DiscoveryConfiguration configuration, Pageable page, Projection projection) {
        DiscoverySearchFilterFacet field = configuration.getSidebarFacet(facetName);
        SearchFacetEntryRest facetEntryRest = new SearchFacetEntryRest(facetName);
        facetEntryRest.setProjection(projection);
        List facetResults = searchResult.getFacetResult(field);
        if (!facetResults.isEmpty()) {
            facetEntryRest.setFacetType(((DiscoverResult.FacetResult)facetResults.get(0)).getFieldType());
        }
        facetEntryRest.setFacetLimit(field.getFacetLimit());
        facetEntryRest.setHasMore(facetResults.size() > page.getPageSize());
        return facetEntryRest;
    }
}

