/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.authorization;

import java.io.Serializable;
import java.sql.SQLException;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.dspace.app.rest.model.BaseObjectRest;
import org.dspace.app.rest.repository.DSpaceRestRepository;
import org.dspace.app.rest.repository.ReloadableEntityObjectRepository;
import org.dspace.app.rest.utils.Utils;
import org.dspace.core.Context;
import org.dspace.eperson.EPerson;
import org.dspace.eperson.factory.EPersonServiceFactory;
import org.dspace.eperson.service.EPersonService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class AuthorizationRestUtil {
    @Autowired
    private Utils utils;

    public String getFeatureName(String id) {
        return this.splitIdParts(id)[1];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BaseObjectRest getObject(Context context, String id) throws SQLException {
        BaseObjectRest baseObjectRest;
        String[] parts = this.splitIdParts(id);
        String objIdStr = parts[3];
        String[] objType = parts[2].split("\\.");
        DSpaceRestRepository repository = this.utils.getResourceRepositoryByCategoryAndModel(objType[0], objType[1]);
        Serializable pk = this.utils.castToPKClass((ReloadableEntityObjectRepository)((Object)repository), objIdStr);
        try {
            context.turnOffAuthorisationSystem();
            baseObjectRest = (BaseObjectRest)repository.findOne(context, pk);
        }
        catch (Throwable throwable) {
            try {
                context.restoreAuthSystemState();
                throw throwable;
            }
            catch (RuntimeException e) {
                throw new IllegalArgumentException("The id " + id + " not resolve to a valid object", e);
            }
        }
        context.restoreAuthSystemState();
        return baseObjectRest;
    }

    public EPerson getEperson(Context context, String id) throws SQLException {
        UUID uuid;
        String epersonIdStr = this.splitIdParts(id)[0];
        if (StringUtils.isBlank((CharSequence)epersonIdStr)) {
            return null;
        }
        try {
            uuid = UUID.fromString(epersonIdStr);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("The authorization id " + id + " contains a reference to an invalid eperson uuid " + epersonIdStr);
        }
        EPersonService service = EPersonServiceFactory.getInstance().getEPersonService();
        EPerson ep = (EPerson)service.find(context, uuid);
        if (ep == null) {
            throw new IllegalArgumentException("No eperson found with the uuid " + epersonIdStr);
        }
        return ep;
    }

    private String[] splitIdParts(String id) {
        String[] idParts = id.split("_");
        String eperson = null;
        String feature = null;
        String objType = null;
        String objId = null;
        if (idParts.length == 4) {
            eperson = idParts[0];
            feature = idParts[1];
            objType = idParts[2];
            objId = idParts[3];
        } else if (idParts.length == 3) {
            feature = idParts[0];
            objType = idParts[1];
            objId = idParts[2];
        } else {
            throw new IllegalArgumentException("the authoization id is invalid, it must have the form [eperson-uuid_]feature-id_object-type_object-id");
        }
        return new String[]{eperson, feature, objType, objId};
    }
}

