/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest;

import java.util.List;
import javax.servlet.Filter;
import org.dspace.app.rest.filter.DSpaceRequestContextFilter;
import org.dspace.app.rest.model.hateoas.DSpaceLinkRelationProvider;
import org.dspace.app.rest.parameter.resolver.SearchFilterResolver;
import org.dspace.app.rest.utils.ApplicationConfig;
import org.dspace.app.rest.utils.DSpaceConfigurationInitializer;
import org.dspace.app.rest.utils.DSpaceKernelInitializer;
import org.dspace.app.util.DSpaceContextListener;
import org.dspace.utils.servlet.DSpaceWebappServletFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.builder.SpringApplicationBuilder;
import org.springframework.boot.web.servlet.support.SpringBootServletInitializer;
import org.springframework.context.ApplicationContextInitializer;
import org.springframework.context.annotation.Bean;
import org.springframework.core.annotation.Order;
import org.springframework.hateoas.server.LinkRelationProvider;
import org.springframework.lang.NonNull;
import org.springframework.web.context.request.RequestContextListener;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.servlet.config.annotation.CorsRegistry;
import org.springframework.web.servlet.config.annotation.ResourceHandlerRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@SpringBootApplication
public class Application
extends SpringBootServletInitializer {
    private static final Logger log = LoggerFactory.getLogger(Application.class);
    @Autowired
    private ApplicationConfig configuration;

    protected SpringApplicationBuilder configure(SpringApplicationBuilder application) {
        return application.sources(new Class[]{Application.class}).initializers(new ApplicationContextInitializer[]{new DSpaceKernelInitializer(), new DSpaceConfigurationInitializer()});
    }

    @Bean
    @Order(value=2)
    protected DSpaceContextListener dspaceContextListener() {
        return new DSpaceContextListener();
    }

    @Bean
    @Order(value=1)
    protected Filter dspaceWebappServletFilter() {
        return new DSpaceWebappServletFilter();
    }

    @Bean
    @Order(value=2)
    protected Filter dspaceRequestContextFilter() {
        return new DSpaceRequestContextFilter();
    }

    @Bean
    public RequestContextListener requestContextListener() {
        return new RequestContextListener();
    }

    @Bean
    protected LinkRelationProvider dspaceLinkRelationProvider() {
        return new DSpaceLinkRelationProvider();
    }

    @Bean
    public WebMvcConfigurer webMvcConfigurer() {
        return new WebMvcConfigurer(){

            public void addCorsMappings(@NonNull CorsRegistry registry) {
                String[] corsAllowedOrigins = Application.this.configuration.getCorsAllowedOrigins();
                boolean corsAllowCredentials = Application.this.configuration.getCorsAllowCredentials();
                if (corsAllowedOrigins != null) {
                    registry.addMapping("/api/**").allowedMethods(new String[]{"*"}).allowCredentials(corsAllowCredentials).allowedOrigins(corsAllowedOrigins).allowedHeaders(new String[]{"Authorization", "Content-Type", "X-Requested-With", "accept", "Origin", "Access-Control-Request-Method", "Access-Control-Request-Headers", "X-On-Behalf-Of"}).exposedHeaders(new String[]{"Access-Control-Allow-Origin", "Access-Control-Allow-Credentials", "Authorization"});
                }
            }

            public void addResourceHandlers(ResourceHandlerRegistry registry) {
                registry.addResourceHandler(new String[]{"/webjars/**"}).addResourceLocations(new String[]{"/webjars/"});
            }

            public void addArgumentResolvers(@NonNull List<HandlerMethodArgumentResolver> argumentResolvers) {
                argumentResolvers.add(new SearchFilterResolver());
            }
        };
    }
}

