/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.utils;

import java.lang.reflect.Method;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.dspace.app.rest.Parameter;
import org.dspace.app.rest.SearchRestMethod;
import org.dspace.app.rest.exception.MissingParameterException;
import org.dspace.app.rest.repository.DSpaceRestRepository;
import org.dspace.app.rest.repository.LinkRestRepository;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.core.MethodParameter;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.core.convert.ConversionException;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.repository.support.QueryMethodParameterConversionException;
import org.springframework.data.web.PagedResourcesAssembler;
import org.springframework.hateoas.core.AnnotationAttribute;
import org.springframework.hateoas.core.MethodParameters;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.util.ReflectionUtils;

/*
 * Exception performing whole class analysis ignored.
 */
@Component
public class RestRepositoryUtils {
    private static final AnnotationAttribute PARAM_ANNOTATION = new AnnotationAttribute(Parameter.class);
    private static final String NAME_NOT_FOUND = "Unable to detect parameter names for query method %s! Use @Param or compile with -parameters on JDK 8.";
    private static final Logger log = Logger.getLogger(RestRepositoryUtils.class);
    @Autowired(required=true)
    @Qualifier(value="mvcConversionService")
    private ConversionService conversionService;

    public boolean haveSearchMethods(DSpaceRestRepository repository) {
        for (Method method : repository.getClass().getMethods()) {
            SearchRestMethod ann = (SearchRestMethod)AnnotationUtils.findAnnotation((Method)method, SearchRestMethod.class);
            if (ann == null) continue;
            return true;
        }
        return false;
    }

    public List<String> listSearchMethods(DSpaceRestRepository repository) {
        LinkedList<String> searchMethods = new LinkedList<String>();
        for (Method method : repository.getClass().getMethods()) {
            SearchRestMethod ann = (SearchRestMethod)AnnotationUtils.findAnnotation((Method)method, SearchRestMethod.class);
            if (ann == null) continue;
            String name = ann.name();
            if (name.isEmpty()) {
                name = method.getName();
            }
            searchMethods.add(name);
        }
        return searchMethods;
    }

    public Method getSearchMethod(String searchMethodName, DSpaceRestRepository repository) {
        Method[] methods;
        Method searchMethod = null;
        for (Method method : methods = ClassUtils.getUserClass(repository.getClass()).getMethods()) {
            SearchRestMethod ann = (SearchRestMethod)AnnotationUtils.findAnnotation((Method)method, SearchRestMethod.class);
            if (ann == null) continue;
            String name = ann.name();
            if (name.isEmpty()) {
                name = method.getName();
            }
            if (!StringUtils.equals((CharSequence)name, (CharSequence)searchMethodName)) continue;
            searchMethod = method;
            break;
        }
        return searchMethod;
    }

    public Object executeQueryMethod(DSpaceRestRepository repository, MultiValueMap<String, Object> parameters, Method method, Pageable pageable, Sort sort, PagedResourcesAssembler assembler) {
        LinkedMultiValueMap result = new LinkedMultiValueMap(parameters);
        MethodParameters methodParameters = new MethodParameters(method, PARAM_ANNOTATION);
        for (MethodParameter parameter : methodParameters.getParameters()) {
            Parameter parameterAnnotation;
            String paramName = this.getParamName(parameter, parameterAnnotation = (Parameter)parameter.getParameterAnnotation(Parameter.class));
            List value = (List)parameters.get((Object)paramName);
            if (value == null) {
                if (parameterAnnotation == null || !parameterAnnotation.required()) continue;
                throw new MissingParameterException(String.format("Required Parameter[%s] Missing", parameter.getParameterName()));
            }
            result.put((Object)paramName, (Object)value);
        }
        return this.invokeQueryMethod(repository, method, (MultiValueMap)result, pageable, sort);
    }

    public Object invokeQueryMethod(DSpaceRestRepository repository, Method method, MultiValueMap<String, ? extends Object> parameters, Pageable pageable, Sort sort) {
        Assert.notNull((Object)method, (String)"Method must not be null!");
        Assert.notNull(parameters, (String)"Parameters must not be null!");
        ReflectionUtils.makeAccessible((Method)method);
        return ReflectionUtils.invokeMethod((Method)method, (Object)repository, (Object[])this.prepareParameters(method, parameters, pageable, sort));
    }

    private Object[] prepareParameters(Method method, MultiValueMap<String, ? extends Object> rawParameters, Pageable pageable, Sort sort) {
        List parameters = new MethodParameters(method, PARAM_ANNOTATION).getParameters();
        if (parameters.isEmpty()) {
            return new Object[0];
        }
        Object[] result = new Object[parameters.size()];
        Sort sortToUse = pageable == null ? sort : pageable.getSort();
        for (int i = 0; i < result.length; ++i) {
            MethodParameter param = (MethodParameter)parameters.get(i);
            Class targetType = param.getParameterType();
            if (Pageable.class.isAssignableFrom(targetType)) {
                result[i] = pageable;
                continue;
            }
            if (Sort.class.isAssignableFrom(targetType)) {
                result[i] = sortToUse;
                continue;
            }
            Parameter parameterAnnotation = (Parameter)param.getParameterAnnotation(Parameter.class);
            String parameterName = this.getParamName(param, parameterAnnotation);
            if (StringUtils.isBlank((CharSequence)parameterName)) {
                throw new IllegalArgumentException(String.format("Unable to detect parameter names for query method %s! Use @Param or compile with -parameters on JDK 8.", ClassUtils.getQualifiedMethodName((Method)method)));
            }
            Object value = RestRepositoryUtils.unwrapSingleElement((List)((List)rawParameters.get((Object)parameterName)));
            result[i] = targetType.isInstance(value) ? value : this.convert(value, param);
        }
        return result;
    }

    private String getParamName(MethodParameter parameter, Parameter parameterAnnotation) {
        String paramName = null;
        if (parameterAnnotation != null) {
            paramName = parameterAnnotation.value();
        }
        if (paramName == null) {
            paramName = parameter.getParameterName();
        }
        return paramName;
    }

    private static Object unwrapSingleElement(List<? extends Object> source) {
        return source == null ? null : (source.size() == 1 ? source.get(0) : source);
    }

    private Object convert(Object value, MethodParameter parameter) {
        try {
            return this.conversionService.convert(value, TypeDescriptor.forObject((Object)value), new TypeDescriptor(parameter));
        }
        catch (ConversionException o_O) {
            throw new QueryMethodParameterConversionException(value, parameter, o_O);
        }
    }

    public Method getLinkMethod(String methodName, LinkRestRepository linkRepository) {
        Method[] methods;
        Method linkMethod = null;
        for (Method m : methods = linkRepository.getClass().getMethods()) {
            if (!StringUtils.equals((CharSequence)m.getName(), (CharSequence)methodName)) continue;
            linkMethod = m;
            break;
        }
        return linkMethod;
    }
}

