/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.submit.step;

import org.atteo.evo.inflector.English;
import org.dspace.app.rest.model.patch.Operation;
import org.dspace.app.rest.model.step.DataLicense;
import org.dspace.app.rest.submit.AbstractRestProcessingStep;
import org.dspace.app.rest.submit.SubmissionService;
import org.dspace.app.rest.submit.factory.PatchOperationFactory;
import org.dspace.app.rest.submit.factory.impl.PatchOperation;
import org.dspace.app.util.SubmissionStepConfig;
import org.dspace.content.Bitstream;
import org.dspace.content.DSpaceObject;
import org.dspace.content.InProgressSubmission;
import org.dspace.core.Context;
import org.dspace.services.model.Request;

public class LicenseStep
extends org.dspace.submit.step.LicenseStep
implements AbstractRestProcessingStep {
    private static final String DCTERMS_RIGHTSDATE = "dcterms.accessRights";

    public DataLicense getData(SubmissionService submissionService, InProgressSubmission obj, SubmissionStepConfig config) throws Exception {
        DataLicense result = new DataLicense();
        Bitstream bitstream = this.bitstreamService.getBitstreamByName(obj.getItem(), "LICENSE", "license.txt");
        if (bitstream != null) {
            String acceptanceDate = this.bitstreamService.getMetadata((DSpaceObject)bitstream, DCTERMS_RIGHTSDATE);
            result.setAcceptanceDate(acceptanceDate);
            result.setUrl(this.configurationService.getProperty("dspace.server.url") + "/api/core/" + English.plural((String)"bitstream") + "/" + bitstream.getID() + "/content");
            result.setGranted(true);
        }
        return result;
    }

    public void doPatchProcessing(Context context, Request currentRequest, InProgressSubmission source, Operation op) throws Exception {
        if (op.getPath().endsWith("granted")) {
            PatchOperation patchOperation = new PatchOperationFactory().instanceOf("granted", op.getOp());
            patchOperation.perform(context, currentRequest, source, op);
        }
    }
}

